/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.DissectionModel;
import it.hurts.sskirillss.relics.entities.DissectionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DissectionRenderer
extends EntityRenderer<DissectionEntity> {
    public DissectionRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(DissectionEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.tickCount < 5) {
            return;
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 1.5, 0.0);
        float ticks = Minecraft.getInstance().isPaused() ? 0.0f : partialTicks;
        float scale = Mth.clamp((float)((float)entityIn.getLifeTime() > 20.0f ? ((float)entityIn.tickCount - 5.0f + ticks) * 0.075f : ((float)entityIn.getLifeTime() - ticks) * 0.075f), (float)0.0f, (float)1.0f) + Math.abs(Mth.sin((float)(((float)entityIn.tickCount + ticks) * 0.01f))) * 0.5f;
        matrixStackIn.scale(scale, scale, scale);
        Vec3 angle = entityIn.getLookAngle();
        double angleY = Math.toDegrees(Math.atan2(angle.x, angle.z));
        double angleZ = Math.toDegrees(Math.atan2(Math.sqrt(angle.x * angle.x + angle.z * angle.z), angle.y));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)angleY));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees((float)angleZ + 90.0f));
        new DissectionModel().renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/dissection.png"))), packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(DissectionEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/dissection.png");
    }
}

