/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class InvisibilityCloakItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"cosmetic_armor").maxLevel(0).build()).ability(AbilityData.builder((String)"invisibility").stat(StatData.builder((String)"duration").initialValue(160.0, 120.0).upgradeModifier(UpgradeOperation.ADD, -10.0).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).thresholdValue(1.0, 9999.0).build()).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"invisibility").gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().beams((player, stack) -> {
            float ticks = (float)player.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            return BeamsData.builder().startColor(new Color(0.5f, 0.5f, 0.5f, Mth.sin((float)(ticks / 10.0f)) / 2.0f + 0.5f).getRGB()).endColor(0x444444).build();
        }).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.HEDGE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        double movementThreshold;
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        int idleTicks = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
        int maxIdleTicks = this.getMaxIdleTicks(slotContext, stack);
        double lengthSqr = slotContext.entity().getKnownMovement().lengthSqr();
        if (lengthSqr < (movementThreshold = 0.005) || entity.isCrouching()) {
            if (idleTicks < maxIdleTicks) {
                ++idleTicks;
            } else {
                if (!entity.hasEffect((Holder)EffectRegistry.VANISHING)) {
                    this.spreadRelicExperience(entity, stack, 1);
                }
                entity.addEffect(new MobEffectInstance((Holder)EffectRegistry.VANISHING, 24, 0, true, false));
            }
        } else {
            idleTicks = 0;
            entity.removeEffect((Holder)EffectRegistry.VANISHING);
        }
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)idleTicks);
    }

    public int getMaxIdleTicks(SlotContext slotContext, ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, "invisibility", "duration"));
    }
}

