/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import top.theillusivec4.curios.api.SlotContext;
import twilightforest.init.TFItems;

@EventBusSubscriber
public class MapleSyrupBottleItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"sugar_rush").stat(StatData.builder((String)"chance").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.ADD, 0.055).formatValue(MathButCool::percentage).build()).stat(StatData.builder((String)"regen_multiplier").initialValue(0.3, 0.5).upgradeModifier(UpgradeOperation.ADD, 0.15).formatValue(MathButCool::percentage).build()).stat(StatData.builder((String)"regen_time").initialValue(140.0, 200.0).upgradeModifier(UpgradeOperation.ADD, 20.0).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).build()).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"sugar_rush").gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.LABYRINTH}).entry(new LootEntry[]{LootEntries.STRONGHOLD}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        int regenerationTicks = (Integer)stack.getOrDefault(DataComponentRegistry.REGENERATION_TICKS, (Object)0);
        if (regenerationTicks > 0) {
            --regenerationTicks;
        }
        stack.set(DataComponentRegistry.REGENERATION_TICKS, (Object)regenerationTicks);
    }

    @SubscribeEvent
    public static void eat(LivingEntityUseItemEvent.Start e) {
        MapleSyrupBottleItem relic;
        ItemStack stack;
        block5: {
            block4: {
                Item item;
                stack = EntityUtils.findEquippedCurio((Entity)e.getEntity(), (Item)((Item)ItemRegistry.MAPLE_SYRUP_BOTTLE.get()));
                if (e.getEntity().level().isClientSide || !((item = stack.getItem()) instanceof MapleSyrupBottleItem)) break block4;
                relic = (MapleSyrupBottleItem)item;
                if (MapleSyrupBottleItem.isAcceptable(e.getItem())) break block5;
            }
            return;
        }
        if (e.getEntity().getRandom().nextDouble() > relic.getStatValue(stack, "sugar_rush", "chance")) {
            e.getItem().remove(DataComponentRegistry.DONT_EAT);
            return;
        }
        e.getItem().set(DataComponentRegistry.DONT_EAT, (Object)true);
    }

    @SubscribeEvent
    public static void eat(LivingEntityUseItemEvent.Finish e) {
        Item item;
        ItemStack original = e.getItem();
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)e.getEntity(), (Item)((Item)ItemRegistry.MAPLE_SYRUP_BOTTLE.get()));
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof MapleSyrupBottleItem)) {
            return;
        }
        MapleSyrupBottleItem relic = (MapleSyrupBottleItem)item;
        if (!e.getEntity().level().isClientSide && MapleSyrupBottleItem.isAcceptable(e.getItem())) {
            int regenerationTicks = (Integer)stack.getOrDefault(DataComponentRegistry.REGENERATION_TICKS, (Object)0);
            int toAdd = (int)Math.round(relic.getStatValue(stack, "sugar_rush", "regen_time"));
            stack.set(DataComponentRegistry.REGENERATION_TICKS, (Object)(regenerationTicks + toAdd));
            relic.spreadRelicExperience(e.getEntity(), stack, 1);
        }
        if (original.has(DataComponentRegistry.DONT_EAT)) {
            e.setResultStack(original);
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent e) {
        MapleSyrupBottleItem relic;
        ItemStack stack;
        block3: {
            block2: {
                Item item;
                stack = EntityUtils.findEquippedCurio((Entity)e.getEntity(), (Item)((Item)ItemRegistry.MAPLE_SYRUP_BOTTLE.get()));
                if (e.getEntity().level().isClientSide || !((item = stack.getItem()) instanceof MapleSyrupBottleItem)) break block2;
                relic = (MapleSyrupBottleItem)item;
                if ((Integer)stack.getOrDefault(DataComponentRegistry.REGENERATION_TICKS, (Object)0) > 0) break block3;
            }
            return;
        }
        e.setAmount(e.getAmount() * (float)(1.0 + relic.getStatValue(stack, "sugar_rush", "regen_multiplier")));
    }

    public static boolean isAcceptable(ItemStack stack) {
        return stack.getItem() == TFItems.MAZE_WAFER.asItem();
    }
}

