/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class ThornCrownItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"thorn_shield").maxLevel(0).build()).ability(AbilityData.builder((String)"poking").stat(StatData.builder((String)"paralyze_chance").initialValue(0.05, 0.1).formatValue(MathButCool::percentage).upgradeModifier(UpgradeOperation.ADD, 0.02).build()).stat(StatData.builder((String)"paralyze_duration").initialValue(10.0, 20.0).formatValue(MathButCool::ticksToSecondsAndRoundSingleDigit).upgradeModifier(UpgradeOperation.ADD, 10.0).build()).stat(StatData.builder((String)"damage").initialValue(1.0, 2.0).formatValue(MathButCool::roundSingleDigit).upgradeModifier(UpgradeOperation.ADD, 0.5).build()).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"poking").gem(GemShape.SQUARE, GemColor.GREEN).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-10036736).endColor(85803).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.HEDGE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Item item;
        LivingEntity entity = slotContext.entity();
        if (entity.level().isClientSide || !((item = stack.getItem()) instanceof ThornCrownItem)) {
            return;
        }
        ThornCrownItem relic = (ThornCrownItem)item;
        List toHurt = entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(0.1), living -> !living.equals((Object)entity) && !EntityUtils.isAlliedTo((Entity)entity, (Entity)living) && living.isAlive());
        toHurt.forEach(living -> {
            if (living.hurt(entity.level().damageSources().thorns((Entity)entity), (float)relic.getStatValue(stack, "poking", "damage")) && living.getRandom().nextDouble() < relic.getStatValue(stack, "poking", "paralyze_chance")) {
                living.addEffect(new MobEffectInstance((Holder)EffectRegistry.PARALYSIS, (int)Math.round(relic.getStatValue(stack, "poking", "paralyze_duration")), 0, false, false));
                relic.spreadRelicExperience(entity, stack, 1);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingIncomingDamageEvent e) {
        block3: {
            block2: {
                LivingEntity entity = e.getEntity();
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.THORN_CROWN.get()));
                ResourceKey type = e.getSource().typeHolder().getKey();
                Item item = stack.getItem();
                if (!(item instanceof ThornCrownItem)) break block2;
                ThornCrownItem relic = (ThornCrownItem)item;
                if (Objects.equals(type, DamageTypes.CACTUS) || Objects.equals(type, DamageTypes.SWEET_BERRY_BUSH) || type != null && type.location().getPath().contains("thorn")) break block3;
            }
            return;
        }
        e.setCanceled(true);
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }
}

