/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.util;

import com.buuz135.replication.api.IMatterType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.unfamily.repae2bridge.component.MatterComponent;
import net.unfamily.repae2bridge.component.ModDataComponents;
import net.unfamily.repae2bridge.item.ModItems;
import net.unfamily.repae2bridge.util.MatterTypeUtil;

public class DynamicMatterRegistry {
    private static final Map<IMatterType, DeferredHolder<Item, Item>> MATTER_TO_ITEM = new HashMap<IMatterType, DeferredHolder<Item, Item>>();
    private static final Map<String, IMatterType> ITEM_TO_MATTER = new HashMap<String, IMatterType>();

    public static void registerMatterItem(IMatterType matterType, DeferredHolder<Item, Item> itemHolder) {
        MATTER_TO_ITEM.put(matterType, itemHolder);
        ITEM_TO_MATTER.put(itemHolder.getId().toString(), matterType);
    }

    public static Item getMatterItem(IMatterType matterType) {
        DeferredHolder<Item, Item> holder = MATTER_TO_ITEM.get(matterType);
        return holder != null ? (Item)holder.get() : null;
    }

    public static IMatterType getMatterType(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        String itemId = stack.getItem().getDescriptionId();
        IMatterType matterType = ITEM_TO_MATTER.get(itemId);
        if (matterType != null) {
            return matterType;
        }
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null) {
            return MatterTypeUtil.getMatterTypeFromComponent(component);
        }
        return null;
    }

    public static ItemStack createMatterStack(IMatterType matterType, int count) {
        Item item = DynamicMatterRegistry.getMatterItem(matterType);
        if (item != null) {
            return new ItemStack((ItemLike)item, count);
        }
        if (ModItems.UNIVERSAL_MATTER != null) {
            return new ItemStack((ItemLike)ModItems.UNIVERSAL_MATTER.get(), count);
        }
        return ItemStack.EMPTY;
    }
}

