/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.pattern;

import com.buuz135.replication.api.IMatterType;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.MatterCost;
import com.leclowndu93150.replication_rs2_bridge.component.MatterComponent;
import com.leclowndu93150.replication_rs2_bridge.component.ModDataComponents;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record PatternSignature(ResourceLocation outputItemId, int outputCount, MatterComponent matterComponent, List<MatterCost> costs) {
    private static final String TAG_ITEM = "Item";
    private static final String TAG_COUNT = "Count";
    private static final String TAG_MATTER = "Matter";
    private static final String TAG_COSTS = "Costs";

    public static PatternSignature from(ItemStack stack, Map<IMatterType, Long> matterCost) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        MatterComponent matterComponent = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        List<MatterCost> entries = matterCost.entrySet().stream().filter(entry -> entry.getKey() != null && (Long)entry.getValue() > 0L).map(entry -> new MatterCost(((IMatterType)entry.getKey()).getName(), (Long)entry.getValue())).sorted(Comparator.comparing(MatterCost::matterName)).toList();
        return new PatternSignature(id, stack.getCount(), matterComponent, entries);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putString(TAG_ITEM, this.outputItemId.toString());
        tag.putInt(TAG_COUNT, this.outputCount);
        if (this.matterComponent != null) {
            MatterComponent.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.matterComponent).result().ifPresent(value -> tag.put(TAG_MATTER, value));
        }
        ListTag costList = new ListTag();
        this.costs.forEach(cost -> costList.add((Object)cost.save()));
        tag.put(TAG_COSTS, (Tag)costList);
        return tag;
    }

    public static PatternSignature load(CompoundTag tag) {
        ResourceLocation itemId = ResourceLocation.parse((String)tag.getString(TAG_ITEM));
        int count = tag.getInt(TAG_COUNT);
        MatterComponent matterComponent = null;
        if (tag.contains(TAG_MATTER)) {
            matterComponent = MatterComponent.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(TAG_MATTER)).result().orElse(null);
        }
        ArrayList<MatterCost> costs = new ArrayList<MatterCost>();
        ListTag costList = tag.getList(TAG_COSTS, 10);
        for (Tag element : costList) {
            costs.add(MatterCost.load((CompoundTag)element));
        }
        return new PatternSignature(itemId, count, matterComponent, costs);
    }
}

