/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.task;

import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeNetworkNode;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.ReplicationPatternTemplate;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.ItemWithSourceId;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.model.TaskSourceInfo;
import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ReplicationTaskHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_LOCAL_REQUEST_COUNTERS = "LocalRequestCounters";
    private static final String TAG_LOCAL_PATTERN_REQUESTS = "LocalPatternRequests";
    private static final String TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE = "LocalPatternRequestsBySource";
    private static final String TAG_LOCAL_ACTIVE_TASKS = "LocalActiveTasks";
    private static final int REQUEST_ACCUMULATION_TICKS = 100;
    private final RepRS2BridgeBlockEntity owner;
    private final Map<UUID, Map<ItemWithSourceId, Integer>> requestCounters = new HashMap<UUID, Map<ItemWithSourceId, Integer>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequests = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequestsBySource = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<String, TaskSourceInfo>> activeTasks = new HashMap<UUID, Map<String, TaskSourceInfo>>();
    private final Map<String, Map<IMatterType, Long>> allocatedMatterByTask = new HashMap<String, Map<IMatterType, Long>>();
    private boolean needsTaskRescan;
    private int requestCounterTicks;

    public ReplicationTaskHandler(RepRS2BridgeBlockEntity owner) {
        this.owner = owner;
    }

    public void queuePatternRequest(ReplicationPatternTemplate template) {
        UUID sourceId = this.owner.getBlockId();
        if (sourceId == null) {
            return;
        }
        ItemStack output = template.outputStack().copy();
        Map counters = this.requestCounters.computeIfAbsent(sourceId, id -> new HashMap());
        ItemWithSourceId key = new ItemWithSourceId(output, sourceId);
        counters.merge(key, output.getCount(), Integer::sum);
        Map sourceRequests = this.patternRequestsBySource.computeIfAbsent(sourceId, id -> new HashMap());
        sourceRequests.merge(output, 1, Integer::sum);
        Map globalRequests = this.patternRequests.computeIfAbsent(sourceId, id -> new HashMap());
        globalRequests.merge(output, 1, Integer::sum);
        this.requestCounterTicks = 100;
    }

    public void tick(@Nullable MatterNetwork replicationNetwork) {
        if (this.needsTaskRescan && replicationNetwork != null) {
            this.relinkActiveTasksFromNetwork(replicationNetwork);
            this.needsTaskRescan = false;
        }
        if (this.requestCounterTicks >= 100) {
            try {
                this.processAccumulatedRequests(replicationNetwork);
                this.requestCounters.clear();
                this.requestCounterTicks = 0;
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Exception in request processing: {}", (Object)e.getMessage());
            }
        } else {
            ++this.requestCounterTicks;
        }
    }

    public void cancelReplicationTaskForRs2Task(TaskId rs2TaskId) {
        ServerLevel server;
        ServerLevel serverLevel;
        UUID blockId = this.owner.getBlockId();
        Level level = this.owner.getLevel();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (server = (ServerLevel)level) : null;
        if (blockId == null || serverLevel == null) {
            return;
        }
        Map<String, TaskSourceInfo> sourceTasks = this.activeTasks.get(blockId);
        if (sourceTasks == null || sourceTasks.isEmpty()) {
            return;
        }
        ArrayList<String> replicationTaskIds = new ArrayList<String>();
        for (Map.Entry<String, TaskSourceInfo> entry : sourceTasks.entrySet()) {
            TaskSourceInfo info = entry.getValue();
            if (info.getRs2TaskId() == null || !info.getRs2TaskId().equals((Object)rs2TaskId)) continue;
            replicationTaskIds.add((String)entry.getKey());
        }
        if (replicationTaskIds.isEmpty()) {
            return;
        }
        MatterNetwork replicationNetwork = this.owner.getNetwork();
        if (replicationNetwork == null) {
            return;
        }
        for (String replicationTaskId : replicationTaskIds) {
            Map<ItemStack, Integer> sourceRequests;
            replicationNetwork.cancelTask(replicationTaskId, (Level)serverLevel);
            TaskSourceInfo info = sourceTasks.remove(replicationTaskId);
            if (info != null && info.getItemStack() != null && (sourceRequests = this.patternRequestsBySource.get(blockId)) != null) {
                sourceRequests.remove(info.getItemStack());
                if (sourceRequests.isEmpty()) {
                    this.patternRequestsBySource.remove(blockId);
                }
            }
            this.allocatedMatterByTask.remove(replicationTaskId);
        }
        if (sourceTasks.isEmpty()) {
            this.activeTasks.remove(blockId);
        }
        this.owner.getMatterStorage().refreshCache();
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode != null) {
            networkNode.refreshStorageInNetwork();
        }
        this.owner.setChanged();
    }

    public void saveLocalRequestState(CompoundTag tag, HolderLookup.Provider registries) {
        Map<ItemStack, Integer> localPatternRequestsBySource;
        Map<ItemStack, Integer> localPatternRequests;
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        Map<ItemWithSourceId, Integer> localCounters = this.requestCounters.get(blockId);
        if (localCounters != null && !localCounters.isEmpty()) {
            tag.put(TAG_LOCAL_REQUEST_COUNTERS, (Tag)this.writeItemWithSourceList(localCounters, registries));
        }
        if ((localPatternRequests = this.patternRequests.get(blockId)) != null && !localPatternRequests.isEmpty()) {
            tag.put(TAG_LOCAL_PATTERN_REQUESTS, (Tag)this.writeItemCountList(localPatternRequests, registries));
        }
        if ((localPatternRequestsBySource = this.patternRequestsBySource.get(blockId)) != null && !localPatternRequestsBySource.isEmpty()) {
            tag.put(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, (Tag)this.writeItemCountList(localPatternRequestsBySource, registries));
        }
    }

    public void loadLocalRequestState(CompoundTag tag, HolderLookup.Provider registries) {
        Map<ItemStack, Integer> requests;
        Map<ItemWithSourceId, Integer> counters;
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        this.requestCounters.remove(blockId);
        this.patternRequests.remove(blockId);
        this.patternRequestsBySource.remove(blockId);
        if (tag.contains(TAG_LOCAL_REQUEST_COUNTERS, 9) && !(counters = this.readItemWithSourceList(tag.getList(TAG_LOCAL_REQUEST_COUNTERS, 10), registries)).isEmpty()) {
            this.requestCounters.put(blockId, counters);
        }
        if (tag.contains(TAG_LOCAL_PATTERN_REQUESTS, 9) && !(requests = this.readItemCountList(tag.getList(TAG_LOCAL_PATTERN_REQUESTS, 10), registries)).isEmpty()) {
            this.patternRequests.put(blockId, requests);
        }
        if (tag.contains(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, 9) && !(requests = this.readItemCountList(tag.getList(TAG_LOCAL_PATTERN_REQUESTS_BY_SOURCE, 10), registries)).isEmpty()) {
            this.patternRequestsBySource.put(blockId, requests);
        }
    }

    public void saveLocalActiveTasks(CompoundTag tag, HolderLookup.Provider registries) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        Map<String, TaskSourceInfo> tasks = this.activeTasks.get(blockId);
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        tag.put(TAG_LOCAL_ACTIVE_TASKS, (Tag)this.writeActiveTaskList(tasks, registries));
    }

    public void loadLocalActiveTasks(CompoundTag tag, HolderLookup.Provider registries) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        this.activeTasks.remove(blockId);
        if (!tag.contains(TAG_LOCAL_ACTIVE_TASKS, 9)) {
            return;
        }
        Map<String, TaskSourceInfo> tasks = this.readActiveTaskList(tag.getList(TAG_LOCAL_ACTIVE_TASKS, 10), registries);
        if (!tasks.isEmpty()) {
            this.activeTasks.put(blockId, tasks);
        }
    }

    public Map<String, Map<IMatterType, Long>> getAllocatedMatterByTask() {
        return this.allocatedMatterByTask;
    }

    public Map<IMatterType, Long> summarizeAllocatedMatter() {
        HashMap<IMatterType, Long> totals = new HashMap<IMatterType, Long>();
        for (Map<IMatterType, Long> allocation : this.allocatedMatterByTask.values()) {
            for (Map.Entry<IMatterType, Long> entry : allocation.entrySet()) {
                totals.merge(entry.getKey(), entry.getValue(), Long::sum);
            }
        }
        return totals;
    }

    public void resetAfterDataLoad() {
        this.forceImmediateProcessing();
        this.needsTaskRescan = true;
    }

    public void forceImmediateProcessing() {
        this.requestCounterTicks = 100;
    }

    public void markNeedsTaskRescan() {
        this.needsTaskRescan = true;
    }

    public void clearPendingOperations() {
        this.requestCounters.clear();
        this.patternRequests.clear();
        this.patternRequestsBySource.clear();
    }

    private void processAccumulatedRequests(@Nullable MatterNetwork network) {
        if (RepRS2BridgeBlockEntity.isWorldUnloading() || network == null || this.requestCounters.isEmpty()) {
            return;
        }
        for (UUID sourceId : this.requestCounters.keySet()) {
            if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
                return;
            }
            Map<ItemWithSourceId, Integer> sourceCounters = this.requestCounters.get(sourceId);
            if (sourceCounters == null) continue;
            for (Map.Entry<ItemWithSourceId, Integer> entry : sourceCounters.entrySet()) {
                if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
                    return;
                }
                ItemWithSourceId key = entry.getKey();
                ItemStack itemStack = key.getItemStack();
                int count = entry.getValue();
                if (count <= 0) continue;
                this.createReplicationTasks(network, itemStack, count, sourceId);
            }
        }
    }

    private void createReplicationTasks(MatterNetwork network, ItemStack itemStack, int totalCount, UUID sourceId) {
        List<MatterPattern> patterns = this.findMatchingPatterns(network, itemStack);
        if (patterns.isEmpty()) {
            LOGGER.warn("Bridge: No replication pattern found for {} ({} requests)", (Object)itemStack.getDisplayName().getString(), (Object)totalCount);
            return;
        }
        MatterPattern pattern = patterns.get(0);
        this.spawnReplicationTask(network, pattern, itemStack, totalCount, sourceId);
    }

    private List<MatterPattern> findMatchingPatterns(MatterNetwork network, ItemStack requestedStack) {
        ArrayList<MatterPattern> matches = new ArrayList<MatterPattern>();
        Level level = this.owner.getLevel();
        if (level == null) {
            return matches;
        }
        for (NetworkElement chipSupplier : network.getChipSuppliers()) {
            BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
            if (!(tile instanceof ChipStorageBlockEntity)) continue;
            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
            for (MatterPattern pattern : chipStorage.getPatterns(level, chipStorage)) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)pattern.getStack(), (ItemStack)requestedStack)) continue;
                matches.add(pattern);
            }
        }
        return matches;
    }

    private void spawnReplicationTask(MatterNetwork network, MatterPattern pattern, ItemStack requestedStack, int amount, UUID sourceId) {
        BlockPos blockPos = this.owner.getBlockPos();
        ReplicationTask task = new ReplicationTask(pattern.getStack().copy(), amount, IReplicationTask.Mode.MULTIPLE, blockPos, false);
        String taskId = task.getUuid().toString();
        network.getTaskManager().getPendingTasks().put(taskId, task);
        Level level = this.owner.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            network.onTaskValueChanged((IReplicationTask)task, serverLevel);
        }
        TaskSourceInfo info = this.getTaskSourceInfo(requestedStack, sourceId);
        Map sourceTasks = this.activeTasks.computeIfAbsent(sourceId, id -> new HashMap());
        sourceTasks.put(taskId, info);
        Map sourceRequests = this.patternRequestsBySource.computeIfAbsent(sourceId, id -> new HashMap());
        int currentPatternRequests = sourceRequests.getOrDefault(requestedStack, 0);
        sourceRequests.put(requestedStack, currentPatternRequests + amount);
        this.extractMatterForTask(pattern, amount, taskId);
    }

    @NotNull
    private TaskSourceInfo getTaskSourceInfo(ItemStack itemStack, UUID sourceId) {
        TaskId rs2TaskId = null;
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode != null) {
            rs2TaskId = networkNode.peekActiveTaskId();
        }
        return new TaskSourceInfo(itemStack, sourceId, rs2TaskId);
    }

    private void extractMatterForTask(MatterPattern pattern, int count, String taskId) {
        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
        if (matterCompound == null) {
            return;
        }
        HashMap<IMatterType, Long> allocated = new HashMap<IMatterType, Long>();
        for (MatterValue matterValue : matterCompound.getValues().values()) {
            IMatterType matterType = matterValue.getMatter();
            if (matterType == null) continue;
            long matterAmount = (long)Math.ceil(matterValue.getAmount()) * (long)count;
            allocated.merge(matterType, matterAmount, Long::sum);
        }
        if (!allocated.isEmpty()) {
            this.allocatedMatterByTask.put(taskId, allocated);
        }
    }

    private void relinkActiveTasksFromNetwork(MatterNetwork network) {
        UUID blockId = this.owner.getBlockId();
        if (blockId == null) {
            return;
        }
        Map tasks = this.activeTasks.computeIfAbsent(blockId, id -> new HashMap());
        HashMap previous = new HashMap(tasks);
        tasks.clear();
        network.getTaskManager().getPendingTasks().forEach((taskId, task) -> {
            if (task == null || task.getSource() == null) {
                return;
            }
            if (!task.getSource().equals((Object)this.owner.getBlockPos())) {
                return;
            }
            TaskSourceInfo existing = (TaskSourceInfo)previous.get(taskId);
            if (existing != null) {
                tasks.put(taskId, new TaskSourceInfo(task.getReplicatingStack(), existing.getSourceId(), existing.getRs2TaskId()));
            } else {
                tasks.put(taskId, new TaskSourceInfo(task.getReplicatingStack(), blockId));
            }
        });
    }

    private ListTag writeItemWithSourceList(Map<ItemWithSourceId, Integer> map, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        map.forEach((key, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", key.getItemStack().saveOptional(registries));
            entry.putInt("Count", amount.intValue());
            entry.putUUID("Owner", key.getSourceId());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemWithSourceId, Integer> readItemWithSourceList(ListTag list, HolderLookup.Provider registries) {
        HashMap<ItemWithSourceId, Integer> map = new HashMap<ItemWithSourceId, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            UUID ownerId = entry.contains("Owner") ? entry.getUUID("Owner") : this.owner.getBlockId();
            int amount = entry.getInt("Count");
            map.put(new ItemWithSourceId(stack, ownerId), amount);
        }
        return map;
    }

    private ListTag writeItemCountList(Map<ItemStack, Integer> map, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        map.forEach((stack, amount) -> {
            CompoundTag entry = new CompoundTag();
            entry.put("Stack", stack.saveOptional(registries));
            entry.putInt("Count", amount.intValue());
            list.add((Object)entry);
        });
        return list;
    }

    private Map<ItemStack, Integer> readItemCountList(ListTag list, HolderLookup.Provider registries) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            map.put(stack, entry.getInt("Count"));
        }
        return map;
    }

    private ListTag writeActiveTaskList(Map<String, TaskSourceInfo> tasks, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        tasks.forEach((taskId, info) -> {
            CompoundTag entry = new CompoundTag();
            entry.putString("TaskId", taskId);
            entry.put("Stack", info.getItemStack().saveOptional(registries));
            if (info.getRs2TaskId() != null) {
                entry.putUUID("Rs2TaskId", info.getRs2TaskId().id());
            }
            list.add((Object)entry);
        });
        return list;
    }

    private Map<String, TaskSourceInfo> readActiveTaskList(ListTag list, HolderLookup.Provider registries) {
        HashMap<String, TaskSourceInfo> map = new HashMap<String, TaskSourceInfo>();
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)entry.getCompound("Stack")).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            String taskId = entry.getString("TaskId");
            TaskId rs2TaskId = null;
            if (entry.contains("Rs2TaskId")) {
                rs2TaskId = new TaskId(entry.getUUID("Rs2TaskId"));
            }
            map.put(taskId, new TaskSourceInfo(stack, this.owner.getBlockId(), rs2TaskId));
        }
        return map;
    }
}

