/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"respawningstructures").then(((LiteralArgumentBuilder)Commands.literal((String)"respawnClosestStructure").requires(stack -> stack.hasPermission(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()));
            for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x << 4, 0, start.z << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x + x << 4, 0, start.z + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.structureManager().fillStartsForStructure((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.getBoundingBox().getCenter(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).distSqr((Vec3i)BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").withStyle(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Respawning structure: " + String.valueOf(((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).getStructure())))).append((Component)Component.literal((String)(" at: " + String.valueOf(((Map.Entry)sortedStructures.get(0)).getKey()))).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getX() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getY() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getZ())))));
            RespawnManager.respawnStructure(world, RespawnManager.getForPos(world, ((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).getBoundingBox().getCenter(), false), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"setClosestStructureRespawningFlag").requires(stack -> stack.hasPermission(2))).then(Commands.argument((String)"doesrespawn", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean shouldRespawn = BoolArgumentType.getBool((CommandContext)context, (String)"doesrespawn");
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()));
            for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x << 4, 0, start.z << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x + x << 4, 0, start.z + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.structureManager().fillStartsForStructure((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.getBoundingBox().getCenter(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).distSqr((Vec3i)BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").withStyle(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Set respawn to " + shouldRespawn + " for structure: " + String.valueOf(((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)((StructureStart)((Map.Entry)sortedStructures.get(0)).getValue()).getStructure())))).append((Component)Component.literal((String)(" at: " + String.valueOf(((Map.Entry)sortedStructures.get(0)).getKey()))).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getX() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getY() + " " + ((BlockPos)((Map.Entry)sortedStructures.get(0)).getKey()).getZ())))));
            RespawnManager.getForPos((ServerLevel)world, (BlockPos)((StructureStart)((Map.Entry)sortedStructures.get((int)0)).getValue()).getBoundingBox().getCenter(), (boolean)false).disabledRespawn = !shouldRespawn;
            RespawnLevelData respawnData = (RespawnLevelData)((CommandSourceStack)context.getSource()).getLevel().getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
            if (respawnData != null) {
                respawnData.setDirty();
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"listNearbyStructures").requires(stack -> stack.hasPermission(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()));
            for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x << 4, 0, start.z << 4)).entrySet()) {
                structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
            }
            if (structures.isEmpty()) {
                for (int x = -5; x < 5; ++x) {
                    for (int z = -5; z < 5; ++z) {
                        for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x + x << 4, 0, start.z + z << 4)).entrySet()) {
                            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                        }
                    }
                }
            }
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.structureManager().fillStartsForStructure((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.getBoundingBox().getCenter(), structureStart));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).distSqr((Vec3i)BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))));
            if (sortedStructures.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"No Structure nearby, anything visible nearby is not an actual structure but just a feature, those can't respawn").withStyle(ChatFormatting.RED));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Structures: ").withStyle(ChatFormatting.BLUE));
            for (Map.Entry entry : sortedStructures) {
                StructureData data = RespawnManager.getForPos(((CommandSourceStack)context.getSource()).getLevel(), (BlockPos)entry.getKey(), false);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.valueOf(data.id)).append((Component)Component.literal((String)(" at: {" + ((BlockPos)entry.getKey()).toShortString() + "}")).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)entry.getKey()).getX() + " " + ((BlockPos)entry.getKey()).getY() + " " + ((BlockPos)entry.getKey()).getZ()))).append((Component)Component.literal((String)" {stats}").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/respawningstructures structureRespawnStatus " + ((BlockPos)entry.getKey()).getX() + " " + ((BlockPos)entry.getKey()).getY() + " " + ((BlockPos)entry.getKey()).getZ()))))));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"structureRespawnStatus").requires(stack -> stack.hasPermission(2))).then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            StructureData data = RespawnManager.getForPos(((CommandSourceStack)context.getSource()).getLevel(), pos, false);
            if (data == null) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"No structure at this position"));
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Structure: " + String.valueOf(data.id))).withStyle(ChatFormatting.YELLOW));
            StructureData.RespawnStatus status = data.canRespawn(((CommandSourceStack)context.getSource()).getLevel());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Respawn status: " + String.valueOf((Object)status))).withStyle(status.isBlocked() ? ChatFormatting.RED : ChatFormatting.YELLOW));
            int minutes_remaining = Math.max(0, (int)(0.016666666666666666 * (double)((long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L - (((RespawnLevelData)((CommandSourceStack)context.getSource()).getLevel().getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata")).getLevelTime() - data.lastActivity))));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Remaining minutes until respawn: " + minutes_remaining)).withStyle(minutes_remaining == 0 ? ChatFormatting.GREEN : ChatFormatting.RED));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Statistics:").withStyle(ChatFormatting.YELLOW));
            ((CommandSourceStack)context.getSource()).sendSystemMessage(data.getStats(((CommandSourceStack)context.getSource()).getLevel()));
            return 1;
        })));
    }
}

