/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class ShieldingTileEntity
extends BlockEntity {
    private BlockPos shieldProjector;
    private BlockState mimic;
    public static final ModelProperty<Integer> ICON_TOPDOWN = new ModelProperty();
    public static final ModelProperty<Integer> ICON_SIDE = new ModelProperty();
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<ShieldRenderData> RENDER_DATA = new ModelProperty();
    private static final ShieldRenderData DEFAULT_RENDER_DATA = new ShieldRenderData(1.0f, 1.0f, 1.0f, 1.0f, ShieldTexture.SHIELD);

    public ShieldingTileEntity(BlockPos pos, BlockState state) {
        super(ShieldModule.TYPE_SHIELDING.get(), pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.saveClient(nbtTag);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (blockEntity, provider) -> nbtTag);
    }

    @Nonnull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveClient(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadClient(pkt.getTag(), provider);
        this.requestModelDataUpdate();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    public BlockPos getShieldProjector() {
        return this.shieldProjector;
    }

    public void setShieldProjector(BlockPos shieldProjector) {
        this.shieldProjector = shieldProjector;
        this.setChanged();
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.setChanged();
    }

    @Nonnull
    public ModelData getModelData() {
        BlockEntity te;
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        int topdown = (z & 1) * 2 + (x & 1);
        int side = (y & 1) * 2 + (x + z & 1);
        ShieldRenderData renderData = DEFAULT_RENDER_DATA;
        if (this.shieldProjector != null && (te = this.level.getBlockEntity(this.shieldProjector)) instanceof ShieldProjectorTileEntity) {
            ShieldProjectorTileEntity shield = (ShieldProjectorTileEntity)te;
            renderData = shield.getRenderData();
        }
        return ModelData.builder().with(ICON_SIDE, (Object)side).with(ICON_TOPDOWN, (Object)topdown).with(MIMIC, (Object)this.mimic).with(RENDER_DATA, (Object)renderData).build();
    }

    public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.shieldProjector = new BlockPos(tag.getInt("sx"), tag.getInt("sy"), tag.getInt("sz"));
        this.mimic = tag.contains("mimic") ? NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("mimic")) : null;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.saveClient(tag);
    }

    private void saveClient(CompoundTag tag) {
        if (this.shieldProjector != null) {
            tag.putInt("sx", this.shieldProjector.getX());
            tag.putInt("sy", this.shieldProjector.getY());
            tag.putInt("sz", this.shieldProjector.getZ());
        }
        if (this.mimic != null) {
            CompoundTag camoNbt = NbtUtils.writeBlockState((BlockState)this.mimic);
            tag.put("mimic", (Tag)camoNbt);
        }
    }

    private void loadClient(CompoundTag tag, HolderLookup.Provider provider) {
        this.shieldProjector = new BlockPos(tag.getInt("sx"), tag.getInt("sy"), tag.getInt("sz"));
        this.mimic = tag.contains("mimic") ? NbtUtils.readBlockState((HolderGetter)((HolderGetter)provider.lookup(Registries.BLOCK).get()), (CompoundTag)tag.getCompound("mimic")) : null;
    }
}

