/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.Tags;

public class ShapeBlockInfo {
    private static final Col COL_DEFAULT = new Col(0.5f, 0.3f, 0.5f);
    private static final Col COL_LAVA = new Col(0.83137256f, 0.3529412f, 0.07058824f);
    private static final Col COL_NETHERBRICK = new Col(0.1764706f, 0.09019608f, 0.105882354f);
    private static final Col COL_SCANNER = new Col(0.0f, 0.0f, 0.8862745f);
    private static final IBlockRender BD_RAIL = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_GRASS = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_TORCH = new DefaultRender(0.4f, 0.7f);
    private static final IBlockRender BD_FLOWER = new DefaultRender(0.4f, 0.6f);
    private static final IBlockRender BD_MUSHROOM = new DefaultRender(0.3f, 0.5f);
    private static final IBlockRender BD_BARS = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_VINE = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_WALL = new DefaultRender(0.25f, 0.9f);
    private static final IBlockRender BD_FENCE = new DefaultRender(0.3f, 0.9f);
    private static final IBlockRender BD_SLAB = new DefaultRender(0.05f, 0.5f);
    private static final IBlockRender BD_SLAB_UPPER = new UpperslabRender(0.05f, 0.5f);
    private static final IBlockRender BD_SNOWLAYER = new DefaultRender(0.0f, 0.3f);
    private static final IBlockRender BD_FIRE = new DefaultRender(0.1f, 0.3f);
    private static final IBlockRender BD_REDSTONE = new DefaultRender(0.3f, 0.1f);
    private static final IBlockRender BD_CHEST = new DefaultRender(0.05f, 0.8f);
    private static final IBlockRender BD_TRAPDOOR = new DefaultRender(0.05f, 0.1f);
    private static final IBlockRender BD_BUTTON = new DefaultRender(0.4f, 0.1f);
    private final Col col;
    private final IBlockRender render;
    private static final Set<Block> nonSolidBlocks = new HashSet<Block>();

    public static boolean isNonSolidBlock(Block b) {
        return nonSolidBlocks.contains(b);
    }

    public ShapeBlockInfo(Col col, IBlockRender render) {
        this.col = col;
        this.render = render;
    }

    private static IBlockRender getBlockRender(BlockState state) {
        if (state == null) {
            return null;
        }
        IBlockRender render = null;
        Block block = state.getBlock();
        Collection tags = TagTools.getTags((Block)block);
        if (block == Blocks.TORCH || block == Blocks.REDSTONE_TORCH) {
            render = BD_TORCH;
        } else if (tags.contains(BlockTags.SLABS)) {
            render = state.hasProperty((Property)SlabBlock.TYPE) && state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM ? BD_SLAB : BD_SLAB_UPPER;
        } else if (block == Blocks.SNOW) {
            render = BD_SNOWLAYER;
        } else if (tags.contains(BlockTags.WALLS)) {
            render = BD_WALL;
        } else if (block == Blocks.IRON_BARS || block == Blocks.LADDER) {
            render = BD_BARS;
        } else if (block == Blocks.VINE) {
            render = BD_VINE;
        } else if (tags.contains(BlockTags.SMALL_FLOWERS) || tags.contains(BlockTags.CORAL_PLANTS) || block == Blocks.WHEAT || block == Blocks.CARROTS || block == Blocks.POTATOES || block == Blocks.BEETROOTS) {
            render = BD_FLOWER;
        } else if (block == Blocks.TALL_GRASS) {
            render = BD_GRASS;
        } else if (tags.contains(BlockTags.RAILS)) {
            render = BD_RAIL;
        } else if (block == Blocks.RED_MUSHROOM || block == Blocks.BROWN_MUSHROOM) {
            render = BD_MUSHROOM;
        } else if (block == Blocks.FIRE) {
            render = BD_FIRE;
        } else if (block == Blocks.REDSTONE_WIRE) {
            render = BD_REDSTONE;
        } else if (tags.contains(Tags.Blocks.CHESTS)) {
            render = BD_CHEST;
        } else if (tags.contains(BlockTags.TRAPDOORS) || tags.contains(BlockTags.WOODEN_PRESSURE_PLATES) || block == Blocks.OAK_PRESSURE_PLATE || block == Blocks.STONE_PRESSURE_PLATE) {
            render = BD_TRAPDOOR;
        } else if (block == Blocks.LEVER || tags.contains(BlockTags.BUTTONS) || tags.contains(BlockTags.WOODEN_BUTTONS)) {
            render = BD_BUTTON;
        } else if (tags.contains(BlockTags.FENCES) || tags.contains(BlockTags.WOODEN_FENCES)) {
            render = BD_FENCE;
        }
        return render;
    }

    private static Col getColor(BlockState state) {
        if (state == null) {
            return COL_DEFAULT;
        }
        Block block = state.getBlock();
        MapColor mapColor = null;
        try {
            mapColor = state.getMapColor((BlockGetter)Minecraft.getInstance().level, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            mapColor = MapColor.COLOR_RED;
        }
        Col col = block == Blocks.LAVA ? COL_LAVA : (block == Blocks.NETHER_BRICKS || block == Blocks.NETHER_BRICK_FENCE || block == Blocks.NETHER_BRICK_STAIRS ? COL_NETHERBRICK : (block == BuilderModule.SUPPORT.get() ? COL_DEFAULT : new Col((float)(mapColor.col >> 16 & 0xFF) / 255.0f, (float)(mapColor.col >> 8 & 0xFF) / 255.0f, (float)(mapColor.col & 0xFF) / 255.0f)));
        float r = col.getR();
        float g = col.getG();
        float b = col.getB();
        if (r * 1.2f > 1.0f) {
            r = 0.825f;
        }
        if (g * 1.2f > 1.0f) {
            g = 0.825f;
        }
        if (b * 1.2f > 1.0f) {
            b = 0.825f;
        }
        col = new Col(r, g, b);
        return col;
    }

    @Nonnull
    public static ShapeBlockInfo getBlockInfo(Map<BlockState, ShapeBlockInfo> palette, BlockState state) {
        ShapeBlockInfo info = palette.get(state);
        if (info != null) {
            return info;
        }
        info = new ShapeBlockInfo(ShapeBlockInfo.getColor(state), ShapeBlockInfo.getBlockRender(state));
        palette.put(state, info);
        return info;
    }

    public Col getCol() {
        return this.col;
    }

    public IBlockRender getRender() {
        return this.render;
    }

    public boolean isNonSolid() {
        return this.render != null;
    }

    static class Col {
        private final float r;
        private final float g;
        private final float b;

        public Col(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }
    }

    static interface IBlockRender {
        public void render(BufferBuilder var1, int var2, float var3, float var4, float var5);
    }

    static class DefaultRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public DefaultRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.addVertex(this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, this.height, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, 0.0f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.0f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, this.height, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, this.height, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, 0.0f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, this.height, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, this.height, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, 0.0f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
        }
    }

    static class UpperslabRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public UpperslabRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.addVertex(this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, 0.5f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.5f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.offset, 0.5f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, this.height + 0.5f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.offset, 0.5f, 1.0f - this.offset + (float)z).setColor(r, g, b, a);
        }
    }

    static class BlockRender
    implements IBlockRender {
        private final float height;
        private final float xoffset;
        private final float zoffset;

        public BlockRender(float xoffset, float zoffset, float height) {
            this.height = 1.0f;
            this.xoffset = xoffset;
            this.zoffset = zoffset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.addVertex(this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.xoffset, this.height, this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r * 0.8f, g * 0.8f, b * 0.8f, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.xoffset, this.height, this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r * 1.2f, g * 1.2f, b * 1.2f, a);
            buffer.addVertex(this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.xoffset, this.height, this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.xoffset, this.height, 1.0f - this.zoffset + (float)z).setColor(r, g, b, a);
            buffer.addVertex(1.0f - this.xoffset, 0.0f, 1.0f - this.zoffset + (float)z).setColor(r, g, b, a);
        }
    }
}

