/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.type.ImageTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.type.PlayerFaceTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.type.TextElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public abstract class ListEntryLoader {
    private String type;
    @SerializedName(value="entry_template")
    private AbstractListLayoutTemplate.ListEntry entryTemplate;
    @SerializedName(value="widget_width")
    private int widgetWidth;
    @SerializedName(value="widget_height")
    private int widgetHeight;
    private boolean carousel;

    public ListEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        this.type = type;
        this.entryTemplate = entryTemplate;
    }

    public String getType() {
        return this.type;
    }

    public int getWidgetWidth() {
        return this.widgetWidth;
    }

    public int getWidgetHeight() {
        return this.widgetHeight;
    }

    public boolean isCarousel() {
        return this.carousel;
    }

    public AbstractListLayoutTemplate.ListEntry getEntryTemplate() {
        return this.entryTemplate;
    }

    public abstract CompletableFuture<List<ListEntryTemplate>> loadEntries(@Nullable VariableStorage var1);

    static List<ElementTemplate<?>> processElements(AbstractListLayoutTemplate.ListEntry entryTemplate, VariableStorage storage) {
        ArrayList elements = new ArrayList();
        for (ElementTemplate<?> element : entryTemplate.elements()) {
            if (element instanceof TextElementTemplate) {
                TextElementTemplate textElement = (TextElementTemplate)element;
                Component replacedText = VariableProcessor.processComponent(textElement.getText(), storage);
                elements.add(new TextElementTemplate(textElement.getType(), textElement.getId(), textElement.getPosition(), textElement.getCallback(), replacedText, textElement.getAlignment(), textElement.getFormatter(), textElement.getTooltip(), textElement.isWrap(), textElement.isShadow(), textElement.getOptions(), textElement.getRequiredDisplayVariable()));
                continue;
            }
            if (element instanceof PlayerFaceTemplate) {
                PlayerFaceTemplate faceElement = (PlayerFaceTemplate)element;
                elements.add(new PlayerFaceTemplate(faceElement.getType(), faceElement.getId(), faceElement.getPosition(), faceElement.getCallback(), VariableProcessor.process(faceElement.getUuid(), storage), faceElement.getRequiredDisplayVariable()));
                continue;
            }
            if (element instanceof ImageTemplate) {
                ImageTemplate imageTemplate = (ImageTemplate)element;
                elements.add(new ImageTemplate(imageTemplate.getType(), imageTemplate.getId(), imageTemplate.getPosition(), imageTemplate.getCallback(), VariableProcessor.process(imageTemplate.getIcon(), storage), imageTemplate.getTooltip(), imageTemplate.hasHoverBorder(), imageTemplate.getOptions(), imageTemplate.getRequiredDisplayVariable()));
                continue;
            }
            elements.add(element);
        }
        return elements;
    }

    public record ListEntryTemplate(AbstractListLayoutTemplate.ListEntry entry, VariableStorage storage) {
    }
}

