/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.game.client.mod.RocketClientMod;
import org.jetbrains.annotations.Nullable;

public class ServerQuery {
    private static final Gson GSON = new Gson();
    private static final int PROTOCOL_VERSION = 763;
    private static final int MAX_VARINT_SIZE = 5;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;

    public static CompletableFuture<PingResponse> query(InetSocketAddress queryAddress) {
        return CompletableFuture.supplyAsync(() -> {
            PingResponse pingResponse;
            Socket socket = new Socket();
            try {
                byte[] buffer;
                socket.connect(queryAddress, 10000);
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
                try (DataOutputStream handshake = new DataOutputStream(byteArrayStream);){
                    handshake.write(0);
                    ServerQuery.writeVarInt(handshake, 763);
                    ServerQuery.writeVarInt(handshake, queryAddress.getAddress().getHostAddress().length());
                    handshake.writeBytes(queryAddress.getAddress().getHostAddress());
                    handshake.writeShort(queryAddress.getPort());
                    ServerQuery.writeVarInt(handshake, 1);
                }
                try (DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());){
                    ServerQuery.writeVarInt(dataOutputStream, byteArrayStream.size());
                    dataOutputStream.write(byteArrayStream.toByteArray());
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeByte(0);
                    try (DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());){
                        ServerQuery.readVarInt(dataInputStream);
                        ServerQuery.readVarInt(dataInputStream);
                        int length = ServerQuery.readVarInt(dataInputStream);
                        buffer = new byte[length];
                        dataInputStream.readFully(buffer);
                    }
                }
                pingResponse = (PingResponse)GSON.fromJson(new String(buffer, StandardCharsets.UTF_8), PingResponse.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    RocketClientMod.getLogger().error("Failed to query server {}", (Object)queryAddress, (Object)e);
                    return new PingResponse();
                }
            }
            socket.close();
            return pingResponse;
        });
    }

    public static int readVarInt(DataInputStream stream) throws IOException {
        byte currentByte;
        int value = 0;
        int position = 0;
        do {
            currentByte = stream.readByte();
            value |= (currentByte & 0x7F) << position++ * 7;
            if (position <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((currentByte & 0x80) == 128);
        return value;
    }

    private static void writeVarInt(DataOutputStream stream, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            stream.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        stream.writeByte(value);
    }

    public static class PingResponse {
        private Players players;

        public PingResponse() {
        }

        public PingResponse(@Nullable String description, Players players) {
            this.players = players;
        }

        public PingResponse(@Nullable String description, int maxPlayers, int onlinePlayers) {
            this.players = new Players(maxPlayers, onlinePlayers);
        }

        public Players getPlayers() {
            return this.players == null ? new Players() : this.players;
        }

        public static class Players {
            private int max;
            private int online;
            private List<Player> sample;

            public Players() {
            }

            public Players(int max, int online) {
                this.max = max;
                this.online = online;
            }

            public List<Player> getSample() {
                return this.sample == null ? List.of() : this.sample;
            }

            public static class Player {
                private String name;
                private UUID id;

                public Player() {
                }

                public Player(String name, UUID id) {
                    this.name = name;
                    this.id = id;
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }
}

