/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost;

import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tarantel.chickenroost.ModCreativeModeTabs;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.entity.ModEntities;
import net.tarantel.chickenroost.handler.ModHandlers;
import net.tarantel.chickenroost.item.ModItems;
import net.tarantel.chickenroost.networking.ModNetworking;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.util.ClientBiomeCache;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.GsonChickenReader;
import net.tarantel.chickenroost.util.ModDataComponents;
import net.tarantel.chickenroost.util.ModEntitySpawnMob;
import net.tarantel.chickenroost.util.ModEntitySpawnMonster;
import org.slf4j.Logger;

@Mod(value="chicken_roost")
public class ChickenRoostMod {
    public static final String MODID = "chicken_roost";
    public static final Logger LOGGER = LogUtils.getLogger();
    @Deprecated
    public static final Random RANDOM = new Random();

    public ChickenRoostMod(IEventBus bus, ModContainer modContainer) throws FileNotFoundException {
        bus.addListener(ModNetworking::onRegisterPayloadHandlers);
        GsonChickenReader.readItemsFromFile();
        ModCreativeModeTabs.register(bus);
        ModDataComponents.register(bus);
        ModEntities.register(bus);
        ModItems.register(bus);
        ModEntitySpawnMonster.SERIALIZER.register(bus);
        ModEntitySpawnMob.SERIALIZER.register(bus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        ModBlocks.BLOCKS.register(bus);
        ModBlockEntities.register(bus);
        bus.addListener(this::registerCapabilities);
        ModHandlers.register(bus);
        ModRecipes.RECIPE_SERIALIZERS.register(bus);
        ModRecipes.RECIPE_TYPES.register(bus);
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::addCreative);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ModBlockEntities.registerCapabilities(event);
    }

    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModCreativeModeTabs.TAB_CHICKEN_ROOST_TAB.get()) {
            int i;
            for (i = 0; i < ModItems.ITEMS.getEntries().size(); ++i) {
                event.accept((ItemLike)((Item)((DeferredHolder)ModItems.ITEMS.getEntries().stream().toList().get(i)).get()).asItem());
            }
            for (i = 0; i < ModItems.CHICKENITEMS.getEntries().size(); ++i) {
                event.accept((ItemLike)((Item)((DeferredHolder)ModItems.CHICKENITEMS.getEntries().stream().toList().get(i)).get()).asItem());
            }
            event.accept((ItemLike)ModBlocks.BREEDER.get());
            event.accept((ItemLike)ModItems.TRAINER.get());
            event.accept((ItemLike)ModBlocks.SOUL_EXTRACTOR.get());
            event.accept((ItemLike)ModBlocks.ROOST.get());
            event.accept((ItemLike)ModItems.CHICKENSTORAGE.get());
            event.accept((ItemLike)ModBlocks.SLIMEBLOCK.get());
            event.accept((ItemLike)ModBlocks.COLLECTOR.get());
            event.accept((ItemLike)ModBlocks.FEEDER.get());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("Player: " + event.getEntity().getScoreboardName());
        if (FMLEnvironment.dist.isClient()) {
            ClientBiomeCache.initialize(event.getEntity().level());
        }
    }

    public static ResourceLocation ownresource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static ResourceLocation commonsource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    @EventBusSubscriber(modid="chicken_roost", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void sendImc(RegisterCapabilitiesEvent evt) {
            ModEntities.initChickenConfig();
        }
    }
}

