/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.item.base.RoostUltimateItem;
import net.tarantel.chickenroost.util.ModDataComponents;
import net.tarantel.chickenroost.util.RoostItemContainerContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChickenStorageTile
extends BlockEntity {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2147483){

        protected void onContentsChanged(int slot) {
            ChickenStorageTile.this.setChanged();
            assert (ChickenStorageTile.this.level != null);
            if (!ChickenStorageTile.this.level.isClientSide()) {
                ChickenStorageTile.this.level.sendBlockUpdated(ChickenStorageTile.this.getBlockPos(), ChickenStorageTile.this.getBlockState(), ChickenStorageTile.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() instanceof RoostUltimateItem || stack.getItem() instanceof ChickenSeedBase;
        }
    };

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        int integer = 0;
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.CHICKENSTORAGE.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            integer += this.itemHandler.getStackInSlot(i).getCount();
        }
        itemStack.set((DataComponentType)ModDataComponents.CONTAINER.value(), (Object)RoostItemContainerContents.fromItems((List<ItemStack>)inventory.getItems()));
        itemStack.set((DataComponentType)ModDataComponents.STORAGEAMOUNT.value(), (Object)integer);
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public ChickenStorageTile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CHICKENSTORAGE.get(), pos, state);
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandler;
    }

    public void saveAdditional(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChickenStorageTile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        ChickenStorageTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return new CompoundTag();
    }
}

