/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block;

import com.benbenlaw.routers.block.entity.ImporterBlockEntity;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.networking.packets.SyncChemicalListToClient;
import com.benbenlaw.routers.networking.packets.SyncFluidListToClient;
import com.benbenlaw.routers.screen.ImporterMenu;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImporterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ImporterBlock> CODEC = ImporterBlock.simpleCodec(ImporterBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPE_MAP = new EnumMap<Direction, VoxelShape>(Direction.class);

    private static VoxelShape buildShape(Direction direction) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.84375, (double)0.6875, (double)0.6875, (double)0.90625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.8125, (double)0.6875, (double)0.6875, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.9375, (double)0.75, (double)0.75, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.75, (double)0.999375, (double)0.625, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.75, (double)0.999375, (double)0.4375, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.999375, (double)0.4375, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.1875, (double)0.999375, (double)0.625, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5625, (double)0.999375, (double)0.25, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.999375, (double)0.25, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.5625, (double)0.999375, (double)0.8125, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.375, (double)0.999375, (double)0.8125, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.4375, (double)0.75, (double)0.5625, (double)0.5625, (double)0.8125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.625, (double)0.6875, (double)0.5, (double)0.75));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.3125, (double)0.625, (double)0.5, (double)0.6875, (double)0.75));
        return ImporterBlock.rotateShape(direction, shape);
    }

    private static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        if (Direction.SOUTH == to) {
            return shape;
        }
        VoxelShape rotated = Shapes.empty();
        for (AABB box : shape.toAabbs()) {
            double minX = box.minX;
            double minY = box.minY;
            double minZ = box.minZ;
            double maxX = box.maxX;
            double maxY = box.maxY;
            double maxZ = box.maxZ;
            AABB newBox = switch (to) {
                case Direction.NORTH -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                case Direction.EAST -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                case Direction.WEST -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                case Direction.UP -> new AABB(minX, 1.0 - maxZ, minY, maxX, 1.0 - minZ, maxY);
                case Direction.DOWN -> new AABB(minX, minZ, 1.0 - maxY, maxX, maxZ, 1.0 - minY);
                default -> box;
            };
            rotated = Shapes.or((VoxelShape)rotated, (VoxelShape)Shapes.box((double)newBox.minX, (double)newBox.minY, (double)newBox.minZ, (double)newBox.maxX, (double)newBox.maxY, (double)newBox.maxZ));
        }
        return rotated;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ImporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos1, boolean p_60514_) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ImporterBlockEntity) {
            ImporterBlockEntity entity = (ImporterBlockEntity)blockEntity;
            entity.setFluidHandler(null);
            entity.setItemHandler(null);
            entity.setEnergyStorage(null);
            if (ModList.get().isLoaded("mekanism")) {
                entity.setChemicalHandler(null);
            }
            if (ModList.get().isLoaded("ars_nouveau")) {
                entity.setSourceHandler(null);
            }
            if (ModList.get().isLoaded("industrialforegoingsouls")) {
                entity.setSoulNetwork(null);
                entity.setSoulHandler(null);
            }
            if (ModList.get().isLoaded("pneumaticcraft")) {
                entity.setHeatHandlerPC(null);
                entity.setPressureHandler(null);
            }
        }
    }

    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_MAP.get(state.getValue((Property)FACING));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(RoutersItems.ROUTER_CONNECTOR)) {
            if (state.getBlock() instanceof ImporterBlock) {
                BlockPos savedPos = (BlockPos)stack.get(RoutersDataComponents.IMPORTER_POSITION);
                if (savedPos != null && savedPos.equals((Object)blockPos)) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.routers.importer.removed_pos"), true);
                    stack.remove(RoutersDataComponents.IMPORTER_POSITION);
                } else {
                    stack.set(RoutersDataComponents.IMPORTER_POSITION, (Object)blockPos);
                    player.displayClientMessage((Component)Component.translatable((String)"message.routers.importer.added_pos"), true);
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Use on an Importer Block to set position"));
            }
        } else {
            ImporterBlockEntity importer = (ImporterBlockEntity)level.getBlockEntity(blockPos);
            if (importer instanceof ImporterBlockEntity) {
                ContainerData data = importer.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ImporterMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.routers.importer_block")), buf -> buf.writeBlockPos(blockPos));
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncFluidListToClient(blockPos, (List<FluidStack>)importer.getFluidFilters()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (ModList.get().isLoaded("mekanism")) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncChemicalListToClient(blockPos, (List<ChemicalStack>)importer.getChemicalFilters()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, dir, neighbor, level, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        boolean water = level.getFluidState(pos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)((BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)WATERLOGGED)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)WATERLOGGED)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ImporterBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.routers.importer").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.routers.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return ImporterBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RoutersBlockEntities.IMPORTER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }

    static {
        SHAPE_MAP.put(Direction.EAST, ImporterBlock.buildShape(Direction.WEST));
        SHAPE_MAP.put(Direction.WEST, ImporterBlock.buildShape(Direction.EAST));
        SHAPE_MAP.put(Direction.NORTH, ImporterBlock.buildShape(Direction.NORTH));
        SHAPE_MAP.put(Direction.SOUTH, ImporterBlock.buildShape(Direction.SOUTH));
        SHAPE_MAP.put(Direction.UP, ImporterBlock.buildShape(Direction.DOWN));
        SHAPE_MAP.put(Direction.DOWN, ImporterBlock.buildShape(Direction.UP));
    }
}

