/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.screen.util;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidContainerHelper {
    public static void saveAllFluids(CompoundTag compoundTag, NonNullList<FluidStack> fluids, boolean saveEmpty, HolderLookup.Provider provider) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < fluids.size(); ++i) {
            FluidStack fluidStack = (FluidStack)fluids.get(i);
            if (fluidStack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            listtag.add((Object)fluidStack.save(provider, (Tag)compoundtag));
        }
        if (!listtag.isEmpty() || saveEmpty) {
            compoundTag.put("Fluids", (Tag)listtag);
        }
    }

    public static void loadAllFluids(CompoundTag compoundTag, NonNullList<FluidStack> fluids, HolderLookup.Provider provider) {
        ListTag listtag = compoundTag.getList("Fluids", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= fluids.size()) continue;
            fluids.set(j, (Object)FluidStack.parse((HolderLookup.Provider)provider, (Tag)compoundtag).orElse(FluidStack.EMPTY));
        }
    }
}

