/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.block.tile;

import com.buuz135.refinedstoragerequestify.block.CraftingEmitterBlock;
import com.buuz135.refinedstoragerequestify.block.tile.CraftingEmitterNetworkNode;
import com.buuz135.refinedstoragerequestify.container.CraftingEmitterContainer;
import com.buuz135.refinedstoragerequestify.container.CraftingEmitterData;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CraftingEmitterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<CraftingEmitterNetworkNode>
implements NetworkNodeExtendedMenuProvider<CraftingEmitterData> {
    private static final int EXPORT_SLOTS = 9;
    private final FilterWithFuzzyMode filter = FilterWithFuzzyMode.create((ResourceContainer)CraftingEmitterBlockEntity.createFilterContainer(), () -> ((CraftingEmitterBlockEntity)this).setChanged());
    private boolean shouldEmmitRedstone = false;

    public CraftingEmitterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, (AbstractNetworkNode)new CraftingEmitterNetworkNode(16L));
        ((CraftingEmitterNetworkNode)this.mainNetworkNode).setFilter(this.filter);
        ((CraftingEmitterNetworkNode)this.mainNetworkNode).setShouldEmmitRedstone(this::updatePower);
    }

    public static ResourceContainer createFilterContainer() {
        return new ResourceContainerImpl(9, value -> Integer.MAX_VALUE, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    public static ResourceContainer createFilterContainer(CraftingEmitterData interfaceData) {
        ResourceContainer filterContainer = CraftingEmitterBlockEntity.createFilterContainer();
        ResourceContainerData resourceContainerData = interfaceData.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            ((Optional)resourceContainerData.resources().get(i)).ifPresent(resource -> filterContainer.set(ii, resource));
        }
        return filterContainer;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level != null) {
            ((CraftingEmitterNetworkNode)this.mainNetworkNode).setLevel(level);
        }
    }

    public void updatePower(boolean powered) {
        if (this.shouldEmmitRedstone != powered) {
            this.shouldEmmitRedstone = powered;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)CraftingEmitterBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new CraftingEmitterContainer(syncId, player, this, this.filter.getFilterContainer(), this.getExportingIndicators());
    }

    public CraftingEmitterData getMenuData() {
        return new CraftingEmitterData(ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer()), this.getExportingIndicators().getAll());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, CraftingEmitterData> getMenuCodec() {
        return CraftingEmitterData.STREAM_CODEC;
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((CraftingEmitterNetworkNode)this.mainNetworkNode).getLastResult(i)), true);
    }

    private ExportingIndicator toExportingIndicator(@Nullable InterfaceTransferResult result) {
        InterfaceTransferResult interfaceTransferResult = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE_DOES_NOT_ACCEPT_RESOURCE", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (InterfaceTransferResult)interfaceTransferResult, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    public Component getName() {
        return Component.translatable((String)"block.rsrequestify.crafting_emitter");
    }

    public boolean hasCustomName() {
        return false;
    }

    protected InWorldNetworkNodeContainer createMainContainer(CraftingEmitterNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer((BlockEntity)this, (NetworkNode)networkNode).connectionStrategy((ConnectionStrategy)new SimpleConnectionStrategy(this.getBlockPos())).build();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    public boolean getShouldEmmitRedstone() {
        return this.shouldEmmitRedstone;
    }
}

