/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.block.tile;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;

public class RequesterNetworkNode
extends SimpleNetworkNode {
    private FilterWithFuzzyMode filter;
    private UpgradeContainer upgradeContainer;
    private Level level;
    private InterfaceTransferResult[] results;

    public RequesterNetworkNode(long energyUsage) {
        super(energyUsage);
    }

    public void setFilter(FilterWithFuzzyMode filter) {
        this.filter = filter;
        this.results = new InterfaceTransferResult[filter.getFilterContainer().size()];
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setUpgradeContainer(UpgradeContainer upgradeContainer) {
        this.upgradeContainer = upgradeContainer;
    }

    public void doWork() {
        super.doWork();
        if (this.network != null && this.isActive() && this.filter != null && this.level != null && this.level.getGameTime() % 10L == 0L) {
            AutocraftingNetworkComponent craftingComponent = (AutocraftingNetworkComponent)this.network.getComponent(AutocraftingNetworkComponent.class);
            StorageNetworkComponent storageComponent = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
            for (int i = 0; i < this.filter.getFilterContainer().size(); ++i) {
                try {
                    ResourceAmount resource = this.filter.getFilterContainer().get(i);
                    if (resource == null) {
                        this.results[i] = InterfaceTransferResult.EXPORTED;
                        continue;
                    }
                    long amount = resource.amount();
                    long needed = amount - storageComponent.get(resource.resource());
                    if (needed <= 0L) {
                        this.results[i] = InterfaceTransferResult.EXPORTED;
                        continue;
                    }
                    int toRequestMaxAmount = 64 * (1 + 8 * this.upgradeContainer.getAmount((UpgradeItem)Items.INSTANCE.getStackUpgrade()));
                    AutocraftingNetworkComponent.EnsureResult ensure = craftingComponent.ensureTask(resource.resource(), Math.min(needed, (long)toRequestMaxAmount), () -> "Requester", (CancellationToken)new TimeoutableCancellationToken());
                    if (ensure == AutocraftingNetworkComponent.EnsureResult.TASK_CREATED || ensure == AutocraftingNetworkComponent.EnsureResult.TASK_ALREADY_RUNNING) {
                        this.results[i] = InterfaceTransferResult.AUTOCRAFTING_STARTED;
                        continue;
                    }
                    if (ensure != AutocraftingNetworkComponent.EnsureResult.MISSING_RESOURCES) continue;
                    this.results[i] = InterfaceTransferResult.AUTOCRAFTING_MISSING_RESOURCES;
                    continue;
                }
                catch (IllegalStateException e) {
                    this.results[i] = InterfaceTransferResult.RESOURCE_MISSING;
                }
            }
        }
    }

    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
    }

    @Nullable
    public InterfaceTransferResult getLastResult(int slot) {
        if (this.results == null) {
            return null;
        }
        return this.results[slot];
    }
}

