/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.lib;

import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.schematicenergistics.lib.CraftingRequest;
import com.schematicenergistics.logic.CannonInterfaceLogic;
import java.util.concurrent.Future;
import net.minecraft.world.level.Level;

public class CraftingHelper {
    private CraftingRequest pendingCraft;
    private final CannonInterfaceLogic cannonLogic;
    private ICraftingLink link;

    public CraftingHelper(CannonInterfaceLogic logic) {
        this.cannonLogic = logic;
    }

    public void startCraft(AEItemKey key, long amount, CalculationStrategy strategy) {
        Level level = this.cannonLogic.getLevel();
        if (key == null || amount <= 0L || level == null || strategy == null) {
            return;
        }
        IManagedGridNode node = this.cannonLogic.getGridNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        ICraftingService service = grid.getCraftingService();
        if (!service.isCraftable((AEKey)key)) {
            return;
        }
        Future future = service.beginCraftingCalculation(this.cannonLogic.getLevel(), this.cannonLogic::getActionSource, (AEKey)key, amount, strategy);
        if (future != null) {
            this.pendingCraft = new CraftingRequest(key, amount, future);
        }
    }

    public void clearPendingCraft() {
        this.pendingCraft = null;
    }

    public void setLink(ICraftingLink link) {
        this.link = link;
    }

    public ICraftingLink getLink() {
        return this.link;
    }

    public CraftingRequest getPendingCraft() {
        return this.pendingCraft;
    }
}

