/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items.components;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.gigabit101.shrink.init.ShrinkComponentTypes;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ShrinkComponentUtils {
    private static final List<String> IGNORED_ENTITY_TAGS = Arrays.asList("Pos", "SleepingX", "SleepingY", "SleepingZ", "Passengers", "leash", "Motion", "Rotation", "FallDistance", "Fire", "Air");
    private static final MapCodec<String> ENTITY_TYPE_ID_MAPCODEC = Codec.STRING.fieldOf("id");
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_MAPCODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    public static void convertLegacyDataComponent(ItemStack stack) {
        DataComponentType LEGACY_COMPONENT_TYPE = (DataComponentType)ShrinkComponentTypes.ENTITY.get();
        if (LEGACY_COMPONENT_TYPE == null || !stack.has(LEGACY_COMPONENT_TYPE)) {
            return;
        }
        String id = (String)stack.get(LEGACY_COMPONENT_TYPE);
        if (!stack.has(DataComponents.ENTITY_DATA) && id != null && !id.isBlank()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("id", id);
            stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        stack.remove(LEGACY_COMPONENT_TYPE);
    }

    public static Optional<ResourceLocation> getEntityTypeId(ItemStack stack) {
        return ShrinkComponentUtils.getEntityData(stack).read(ENTITY_TYPE_ID_MAPCODEC).result().map(ResourceLocation::tryParse);
    }

    public static Optional<EntityType<?>> getEntityType(ItemStack stack) {
        return ShrinkComponentUtils.getEntityData(stack).read(ENTITY_TYPE_MAPCODEC).result();
    }

    public static CustomData getEntityData(ItemStack stack) {
        return (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
    }

    public static CompoundTag stripTag(CompoundTag tag) {
        IGNORED_ENTITY_TAGS.forEach(arg_0 -> ((CompoundTag)tag).remove(arg_0));
        return tag;
    }
}

