/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.simplemagnets.DemagnetizationCoilBlockEntity;
import com.supermartijn642.simplemagnets.SMConfig;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class DemagnetizationCoilAreaHighlighter {
    @SubscribeEvent
    public static void onDrawHighlight(RenderHighlightEvent.Block e) {
        if (!SMConfig.showDemagnetizationArea.get().booleanValue()) {
            return;
        }
        BlockPos pos = e.getTarget().getBlockPos();
        BlockEntity entity = ClientUtils.getWorld().getBlockEntity(pos);
        if (entity instanceof DemagnetizationCoilBlockEntity) {
            PoseStack poseStack = e.getPoseStack();
            poseStack.pushPose();
            Vec3 playerPos = RenderUtils.getCameraPosition();
            poseStack.translate(-playerPos.x, -playerPos.y, -playerPos.z);
            AABB area = ((DemagnetizationCoilBlockEntity)entity).getArea();
            Random random = new Random(entity.getBlockPos().hashCode());
            float red = random.nextFloat();
            float green = random.nextFloat();
            float blue = random.nextFloat();
            float alpha = 0.3f;
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
            poseStack.popPose();
        }
    }
}

