/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTomb
extends BlockEntity {
    private static final int SOULTIMER = 100;
    private final ItemStackHandler handler = new ItemStackHandler(120);
    protected String ownerName = "";
    protected long deathDate;
    public int timer = 0;
    protected UUID ownerId = null;
    private boolean onlyOwnersAccess = true;

    public BlockEntityTomb(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void giveInventory(@Nullable Player player) {
        if (!this.level.isClientSide && player != null && !(player instanceof FakePlayer)) {
            for (int i = this.handler.getSlots() - 1; i >= 0; --i) {
                if (!EntityHelper.autoEquip(this.handler.getStackInSlot(i), player)) continue;
                this.handler.extractItem(i, 64, false);
            }
            IntStream.range(0, this.handler.getSlots()).forEach(ix -> {
                ItemStack stack = this.handler.getStackInSlot(ix);
                if (!stack.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.copy());
                    this.handler.extractItem(ix, 64, false);
                }
            });
            this.removeGraveBy(player);
            if (player.inventoryMenu != null) {
                player.inventoryMenu.broadcastChanges();
            }
            MessageType.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage(player, new Object[0]);
        }
    }

    public void dropInventory(Level level, BlockPos pos) {
        if (this.level != null && !this.level.isClientSide) {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                ItemStack stack = this.handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.handler.extractItem(i, stack.getCount(), false));
            }
        }
    }

    public boolean onlyOwnersCanAccess() {
        return this.onlyOwnersAccess;
    }

    private void removeGraveBy(@Nullable Player player) {
        if (this.level != null) {
            WorldHelper.removeNoEvent(this.level, this.worldPosition);
            if (player != null) {
                this.level.playSound(player, player.blockPosition(), SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void initTombstoneOwner(Player owner) {
        this.deathDate = System.currentTimeMillis();
        this.ownerName = owner.getDisplayName().getString();
        this.ownerId = owner.getUUID();
    }

    public void initTombstoneOwner(GameProfile owner) {
        this.deathDate = 0L;
        this.ownerName = owner.getName();
        this.ownerId = owner.getId();
    }

    public boolean isOwner(Player owner) {
        if (this.ownerId == null || owner == null || !this.hasOwner()) {
            return false;
        }
        return this.ownerId.equals(owner.getUUID());
    }

    String getOwnerName() {
        return this.ownerName;
    }

    boolean hasOwner() {
        return this.ownerName != null && this.ownerName.length() > 0;
    }

    long getOwnerDeathTime() {
        return this.deathDate;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("ownerName", this.ownerName);
        tag.putLong("deathDate", this.deathDate);
        tag.putInt("countTicks", this.timer);
        if (this.ownerId != null) {
            tag.putUUID("ownerid", this.ownerId);
        }
        if (this.handler != null) {
            tag.put("inv", (Tag)this.handler.serializeNBT(registries));
        }
        tag.putBoolean("onlyOwnersAccess", this.onlyOwnersAccess);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.ownerName = compound.getString("ownerName");
        this.deathDate = compound.getLong("deathDate");
        this.timer = compound.getInt("countTicks");
        CompoundTag invTag = compound.getCompound("inv");
        if (this.handler != null) {
            this.handler.deserializeNBT(registries, invTag);
        }
        if (compound.hasUUID("ownerid")) {
            this.ownerId = compound.getUUID("ownerid");
        }
        this.onlyOwnersAccess = compound.getBoolean("onlyOwnersAccess");
        super.loadAdditional(compound, registries);
    }

    public ItemStackHandler getHandler(@Nullable Direction direction) {
        return this.handler;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        this.saveAdditional(compound, provider);
        compound.putString("ownerName", this.ownerName);
        compound.putLong("deathDate", this.deathDate);
        compound.putInt("countTicks", this.timer);
        return compound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean triggerEvent(int id, int type) {
        return true;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntityTomb tile) {
        ClientUtils.produceGraveSmoke(level, tile.worldPosition.getX(), tile.worldPosition.getY(), tile.worldPosition.getZ());
        ++tile.timer;
        if (tile.timer % 100 == 0) {
            ClientUtils.produceGraveSoul(level, tile.worldPosition);
            tile.timer = 1;
        }
        if (level.isClientSide) {
            ClientUtils.produceGraveSmoke(level, blockPos.getX(), blockPos.getY(), blockPos.getZ());
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntityTomb tile) {
        ++tile.timer;
        if ((tile.timer - 1) % 100 == 0) {
            tile.timer = 1;
        }
    }
}

