/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.TransparentParticle;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class ParticleGhost
extends TransparentParticle {
    private final SpriteSet spriteSet;
    private final double mX;
    private final double mZ;

    private ParticleGhost(SpriteSet spriteSet, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(level, x, y + 1.0, z);
        this.mX = motionX;
        this.mZ = motionZ;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.setLifetime(200);
        this.hasPhysics = false;
        this.scale(8.0f);
        this.setColor(1.0f, 1.0f, 1.0f);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            if (this.age == 10) {
                this.xd = this.mX;
                this.zd = this.mZ;
            }
            float ratio = (float)this.age / (float)this.lifetime;
            this.setAlpha((1.0f - ratio) * 0.8f);
            this.setSpriteFromAge(this.spriteSet);
            if (this.level.isClientSide) {
                ClientUtils.produceGraveSmoke((Level)this.level, this.x, this.y - 1.0, this.z);
            }
        }
    }

    protected int getLightColor(float partialTick) {
        int skylight = 15;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            RandomSource rand = level == null ? RandomSource.createThreadSafe() : level.random;
            return new ParticleGhost(this.spriteSet, level, x, y, z, WorldHelper.getRandom(rand, -0.05, 0.05), 0.0, WorldHelper.getRandom(rand, -0.05, 0.05));
        }
    }
}

