/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.proxy;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.RenderTomb;
import com.lothrazar.simpletomb.particle.ParticleCasting;
import com.lothrazar.simpletomb.particle.ParticleGraveSmoke;
import com.lothrazar.simpletomb.particle.ParticleGraveSoul;
import com.lothrazar.simpletomb.particle.ParticleRotatingSmoke;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public class ClientUtils {
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TombRegistry.GRAVE_SMOKE.get(), ParticleGraveSmoke.Factory::new);
        event.registerSpriteSet((ParticleType)TombRegistry.ROTATING_SMOKE.get(), ParticleRotatingSmoke.Factory::new);
        event.registerSpriteSet((ParticleType)TombRegistry.SOUL.get(), ParticleGraveSoul.Factory::new);
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TombRegistry.TOMBSTONE_BLOCK_ENTITY.get(), RenderTomb::new);
    }

    public static void produceGraveSmoke(Level level, double x, double y, double z) {
        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)TombRegistry.GRAVE_SMOKE.get(), x + level.random.nextGaussian(), y, z + level.random.nextGaussian(), 0.0, 0.0, 0.0);
    }

    public static void produceGraveSoul(Level level, BlockPos pos) {
        level.addParticle((ParticleOptions)TombRegistry.SOUL.get(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0);
    }

    public static void produceParticleCasting(LivingEntity caster, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.getInstance();
        if (caster != null && caster.level() instanceof ClientLevel) {
            for (int i = 1; i <= 2; ++i) {
                ClientLevel cworld = (ClientLevel)caster.level();
                ParticleCasting particle = new ParticleCasting(cworld, caster, predic, 0.0, (double)i * 0.5);
                mc.particleEngine.add((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 0.5, (double)(i + 1) * 0.5);
                mc.particleEngine.add((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 1.0, (double)i * 0.5);
                mc.particleEngine.add((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 1.5, (double)(i + 1) * 0.5);
                mc.particleEngine.add((Particle)particle);
                particle = new ParticleCasting(cworld, caster, predic, 2.0, (double)i * 0.5);
                mc.particleEngine.add((Particle)particle);
            }
        }
    }

    public static BlockPos getPlayerPos() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return null;
        }
        return mc.player.blockPosition();
    }
}

