/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.compat;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.PrometheumComponent;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.item.tools.ToolSet;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.sweenus.simplyswords.SimplySwords;
import net.sweenus.simplyswords.compat.mythicmetals.PalladiumSwordItem;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.item.SimplySwordsSwordItem;

public class MythicMetalsCompat {
    static float longsword_modifier = Config.weaponAttribute.typeDamageModifier.longsword_damageModifier;
    static float twinblade_modifier = Config.weaponAttribute.typeDamageModifier.twinblade_damageModifier;
    static float rapier_modifier = Config.weaponAttribute.typeDamageModifier.rapier_damageModifier;
    static float katana_modifier = Config.weaponAttribute.typeDamageModifier.katana_damageModifier;
    static float sai_modifier = Config.weaponAttribute.typeDamageModifier.sai_damageModifier;
    static float spear_modifier = Config.weaponAttribute.typeDamageModifier.spear_damageModifier;
    static float glaive_modifier = Config.weaponAttribute.typeDamageModifier.glaive_damageModifier;
    static float warglaive_modifier = Config.weaponAttribute.typeDamageModifier.warglaive_damageModifier;
    static float cutlass_modifier = Config.weaponAttribute.typeDamageModifier.cutlass_damageModifier;
    static float claymore_modifier = Config.weaponAttribute.typeDamageModifier.claymore_damageModifier;
    static float greataxe_modifier = Config.weaponAttribute.typeDamageModifier.greataxe_damageModifier;
    static float greathammer_modifier = Config.weaponAttribute.typeDamageModifier.greathammer_damageModifier;
    static float chakram_modifier = Config.weaponAttribute.typeDamageModifier.chakram_damageModifier;
    static float scythe_modifier = Config.weaponAttribute.typeDamageModifier.scythe_damageModifier;
    static float halberd_modifier = Config.weaponAttribute.typeDamageModifier.halberd_damageModifier;
    static float longsword_attackspeed = Config.weaponAttribute.typeAttackSpeed.longsword_attackSpeed;
    static float twinblade_attackspeed = Config.weaponAttribute.typeAttackSpeed.twinblade_attackSpeed;
    static float rapier_attackspeed = Config.weaponAttribute.typeAttackSpeed.rapier_attackSpeed;
    static float sai_attackspeed = Config.weaponAttribute.typeAttackSpeed.sai_attackSpeed;
    static float spear_attackspeed = Config.weaponAttribute.typeAttackSpeed.spear_attackSpeed;
    static float katana_attackspeed = Config.weaponAttribute.typeAttackSpeed.katana_attackSpeed;
    static float glaive_attackspeed = Config.weaponAttribute.typeAttackSpeed.glaive_attackSpeed;
    static float warglaive_attackspeed = Config.weaponAttribute.typeAttackSpeed.warglaive_attackSpeed;
    static float cutlass_attackspeed = Config.weaponAttribute.typeAttackSpeed.cutlass_attackSpeed;
    static float claymore_attackspeed = Config.weaponAttribute.typeAttackSpeed.claymore_attackSpeed;
    static float greataxe_attackspeed = Config.weaponAttribute.typeAttackSpeed.greataxe_attackSpeed;
    static float greathammer_attackspeed = Config.weaponAttribute.typeAttackSpeed.greathammer_attackSpeed;
    static float chakram_attackspeed = Config.weaponAttribute.typeAttackSpeed.chakram_attackSpeed;
    static float scythe_attackspeed = Config.weaponAttribute.typeAttackSpeed.scythe_attackSpeed;
    static float halberd_attackspeed = Config.weaponAttribute.typeAttackSpeed.halberd_attackSpeed;
    static float adamantite_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.adamantite_damageModifier.get()).floatValue();
    static float aquarium_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.aquarium_damageModifier.get()).floatValue();
    static float banglum_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.banglum_damageModifier.get()).floatValue();
    static float bronze_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.bronze_damageModifier.get()).floatValue();
    static float carmot_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.carmot_damageModifier.get()).floatValue();
    static float celestium_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.celestium_damageModifier.get()).floatValue();
    static float copper_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.copper_damageModifier.get()).floatValue();
    static float durasteel_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.durasteel_damageModifier.get()).floatValue();
    static float kyber_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.kyber_damageModifier.get()).floatValue();
    static float metallurgium_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.metallurgium_damageModifier.get()).floatValue();
    static float mythril_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.mythril_damageModifier.get()).floatValue();
    static float orichalcum_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.orichalcum_damageModifier.get()).floatValue();
    static float osmium_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.osmium_damageModifier.get()).floatValue();
    static float palladium_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.palladium_damageModifier.get()).floatValue();
    static float prometheum_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.prometheum_damageModifier.get()).floatValue();
    static float quadrillum_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.quadrillum_damageModifier.get()).floatValue();
    static float runite_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.runite_damageModifier.get()).floatValue();
    static float star_platinum_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.starPlatinum_damageModifier.get()).floatValue();
    static float steel_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.steel_damageModifier.get()).floatValue();
    static float stormyx_modifier = ((Float)Config.weaponAttribute.materialDamageModifier.stormyx_damageModifier.get()).floatValue();
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((String)"simplyswords", (ResourceKey)Registries.ITEM);

    private static void registerItems(Map<String, Float> supportedItems) {
        MythicTools.TOOL_MAP.forEach((name, toolSet) -> {
            if (supportedItems.containsKey(name.toLowerCase(Locale.ROOT))) {
                MythicMetalsCompat.registerSwords(toolSet, name, ((Float)supportedItems.get(name)).floatValue());
            }
        });
    }

    private static void registerSwords(ToolSet toolSet, String name, float modifier) {
        Item.Properties settings;
        name = name.toLowerCase(Locale.ROOT);
        String weaponPath = "mythicmetals_compat/" + name + "/" + name + "_";
        Tier material = toolSet.getSword().getTier();
        ItemStack[] repairStacks = material.getRepairIngredient().getItems();
        Item.Properties properties = settings = name.equals("prometheum") ? MythicMetalsCompat.prometheumSettings() : MythicMetalsCompat.defaultSettings();
        if (name.equals("palladium")) {
            MythicMetalsCompat.registerPalladiumTools(material, weaponPath, modifier);
            return;
        }
        ITEM.register(weaponPath + "longsword", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + longsword_modifier)), (float)longsword_attackspeed))));
        ITEM.register(weaponPath + "twinblade", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + twinblade_modifier)), (float)twinblade_attackspeed))));
        ITEM.register(weaponPath + "rapier", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + rapier_modifier)), (float)rapier_attackspeed))));
        ITEM.register(weaponPath + "katana", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + katana_modifier)), (float)katana_attackspeed))));
        ITEM.register(weaponPath + "sai", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + sai_modifier)), (float)sai_attackspeed))));
        ITEM.register(weaponPath + "spear", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + spear_modifier)), (float)spear_attackspeed))));
        ITEM.register(weaponPath + "glaive", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + glaive_modifier)), (float)glaive_attackspeed))));
        ITEM.register(weaponPath + "warglaive", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + warglaive_modifier)), (float)warglaive_attackspeed))));
        ITEM.register(weaponPath + "cutlass", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + cutlass_modifier)), (float)cutlass_attackspeed))));
        ITEM.register(weaponPath + "claymore", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + claymore_modifier)), (float)claymore_attackspeed))));
        ITEM.register(weaponPath + "greathammer", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + greathammer_modifier)), (float)greathammer_attackspeed))));
        ITEM.register(weaponPath + "greataxe", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + greataxe_modifier)), (float)greataxe_attackspeed))));
        ITEM.register(weaponPath + "chakram", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + chakram_modifier)), (float)chakram_attackspeed))));
        ITEM.register(weaponPath + "scythe", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + scythe_modifier)), (float)scythe_attackspeed))));
        ITEM.register(weaponPath + "halberd", () -> new SimplySwordsSwordItem(material, settings.attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + halberd_modifier)), (float)halberd_attackspeed))));
    }

    private static void registerPalladiumTools(Tier material, String weaponPath, float modifier) {
        ITEM.register(weaponPath + "longsword", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + longsword_modifier)), (float)longsword_attackspeed))));
        ITEM.register(weaponPath + "twinblade", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + twinblade_modifier)), (float)twinblade_attackspeed))));
        ITEM.register(weaponPath + "rapier", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + rapier_modifier)), (float)rapier_attackspeed))));
        ITEM.register(weaponPath + "katana", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + katana_modifier)), (float)katana_attackspeed))));
        ITEM.register(weaponPath + "sai", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + sai_modifier)), (float)sai_attackspeed))));
        ITEM.register(weaponPath + "spear", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + spear_modifier)), (float)spear_attackspeed))));
        ITEM.register(weaponPath + "glaive", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + glaive_modifier)), (float)glaive_attackspeed))));
        ITEM.register(weaponPath + "warglaive", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + warglaive_modifier)), (float)warglaive_attackspeed))));
        ITEM.register(weaponPath + "cutlass", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + cutlass_modifier)), (float)cutlass_attackspeed))));
        ITEM.register(weaponPath + "claymore", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + claymore_modifier)), (float)claymore_attackspeed))));
        ITEM.register(weaponPath + "greathammer", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + greathammer_modifier)), (float)greathammer_attackspeed))));
        ITEM.register(weaponPath + "greataxe", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + greataxe_modifier)), (float)greataxe_attackspeed))));
        ITEM.register(weaponPath + "chakram", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + chakram_modifier)), (float)chakram_attackspeed))));
        ITEM.register(weaponPath + "scythe", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + scythe_modifier)), (float)scythe_attackspeed))));
        ITEM.register(weaponPath + "halberd", () -> new PalladiumSwordItem(material, MythicMetalsCompat.defaultSettings().attributes(SwordItem.createAttributes((Tier)material, (int)((int)(modifier + halberd_modifier)), (float)halberd_attackspeed))));
    }

    private static Item.Properties defaultSettings() {
        return new Item.Properties().arch$tab(SimplySwords.SIMPLYSWORDS);
    }

    private static Item.Properties prometheumSettings() {
        return new Item.Properties().component(MythicDataComponents.PROMETHEUM, (Object)PrometheumComponent.DEFAULT);
    }

    public static void init() {
        HashMap<String, Float> supportedItems = new HashMap<String, Float>();
        supportedItems.put("adamantite", Float.valueOf(adamantite_modifier));
        supportedItems.put("aquarium", Float.valueOf(aquarium_modifier));
        supportedItems.put("banglum", Float.valueOf(banglum_modifier));
        supportedItems.put("bronze", Float.valueOf(bronze_modifier));
        supportedItems.put("carmot", Float.valueOf(carmot_modifier));
        supportedItems.put("celestium", Float.valueOf(celestium_modifier));
        supportedItems.put("kyber", Float.valueOf(kyber_modifier));
        supportedItems.put("metallurgium", Float.valueOf(metallurgium_modifier));
        supportedItems.put("mythril", Float.valueOf(mythril_modifier));
        supportedItems.put("orichalcum", Float.valueOf(orichalcum_modifier));
        supportedItems.put("osmium", Float.valueOf(osmium_modifier));
        supportedItems.put("palladium", Float.valueOf(palladium_modifier));
        supportedItems.put("prometheum", Float.valueOf(prometheum_modifier));
        supportedItems.put("quadrillum", Float.valueOf(quadrillum_modifier));
        supportedItems.put("runite", Float.valueOf(runite_modifier));
        supportedItems.put("star_platinum", Float.valueOf(star_platinum_modifier));
        supportedItems.put("steel", Float.valueOf(steel_modifier));
        supportedItems.put("stormyx", Float.valueOf(stormyx_modifier));
        MythicMetalsCompat.registerItems(supportedItems);
        ITEM.register();
    }
}

