/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.modcompat;

import com.faboslav.structurify.common.modcompat.ModCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class TerraCompat
implements ModCompat {
    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.BIOME_REPLACER);
    }

    @Override
    public List<String> getReplacedBiomes(List<String> biomes) {
        ArrayList<String> terraBiomes = new ArrayList<String>();
        Map<ResourceLocation, List<ResourceLocation>> terraBiomeMap = this.getTerraBiomes("com.dfsek.terra.mod.util.BiomeUtil", "getTerraBiomeMap");
        if (terraBiomeMap == null) {
            terraBiomeMap = this.getTerraBiomes("com.dfsek.terra.mod.util.MinecraftUtil", "getTerraBiomeMap");
        }
        if (terraBiomeMap != null) {
            terraBiomeMap.forEach((originalBiome, replacementBiomes) -> {
                String vanillaBiomeName = originalBiome.toString();
                if (biomes.contains(vanillaBiomeName)) {
                    for (ResourceLocation replacementBiome : replacementBiomes) {
                        terraBiomes.add(replacementBiome.toString());
                    }
                }
            });
        }
        return terraBiomes;
    }

    public Map<ResourceLocation, List<ResourceLocation>> getTerraBiomes(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke(null, new Object[0]);
            return (Map)result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

