/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameConfig;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameConfigDeserializer;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameDataDeserializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomFrameLoader {
    private static final String CONFIG_PATH = "custom_frames.json";
    private static final String CONFIG_SUBDIR = "tooltipoverhaul";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomFrameData.class, (Object)new CustomFrameDataDeserializer()).registerTypeAdapter(CustomFrameConfig.class, (Object)new CustomFrameConfigDeserializer()).setPrettyPrinting().create();

    public static Map<ResourceLocation, CustomFrameData> loadCustomFrames(ResourceManager resourceManager, Path configDir) {
        ConcurrentHashMap<ResourceLocation, CustomFrameData> frames = new ConcurrentHashMap<ResourceLocation, CustomFrameData>();
        CustomFrameLoader.loadTooltipOverhaulConfigFrames(frames, configDir, resourceManager);
        Map resources = resourceManager.listResources(CONFIG_SUBDIR, path -> path.getPath().endsWith(CONFIG_PATH));
        TooltipOverhaul.LOGGER.info("Found {} custom frame config files from resource packs", (Object)resources.size());
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (CONFIG_SUBDIR.equals(location.getNamespace())) continue;
            try {
                CustomFrameLoader.loadFramesFromResource((Resource)entry.getValue(), frames, location);
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Error loading custom frames from {}: {}", (Object)location, (Object)e.getMessage());
            }
        }
        TooltipOverhaul.LOGGER.info("Loaded {} custom frame entries total", (Object)frames.size());
        return frames;
    }

    private static void loadTooltipOverhaulConfigFrames(Map<ResourceLocation, CustomFrameData> frames, Path configDir, ResourceManager resourceManager) {
        block15: {
            Path configSubDir = configDir.resolve(CONFIG_SUBDIR);
            Path configFile = configSubDir.resolve(CONFIG_PATH);
            try {
                if (!Files.exists(configSubDir, new LinkOption[0])) {
                    Files.createDirectories(configSubDir, new FileAttribute[0]);
                    TooltipOverhaul.LOGGER.info("Created config directory: {}", (Object)configSubDir);
                }
                if (!Files.exists(configFile, new LinkOption[0])) {
                    CustomFrameLoader.extractDefaultConfigFile(configFile, resourceManager);
                }
                if (Files.exists(configFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(configFile, StandardCharsets.UTF_8);){
                        CustomFrameConfig config = (CustomFrameConfig)GSON.fromJson((Reader)reader, CustomFrameConfig.class);
                        if (config == null || config.getCustomFrames() == null) {
                            TooltipOverhaul.LOGGER.warn("Empty or invalid custom frames config: {}", (Object)configFile);
                            return;
                        }
                        List<CustomFrameData> customFrames = config.getCustomFrames();
                        TooltipOverhaul.LOGGER.info("Found {} frame configs in TooltipOverhaul config", (Object)customFrames.size());
                        CustomFrameLoader.processFrameData(frames, customFrames, CONFIG_SUBDIR);
                        break block15;
                    }
                }
                TooltipOverhaul.LOGGER.warn("Could not find or create config file at {}", (Object)configFile);
            }
            catch (IOException e) {
                TooltipOverhaul.LOGGER.error("Failed to load Tooltip Overhaul config frames: {}", (Object)e.getMessage());
            }
            catch (JsonSyntaxException e) {
                TooltipOverhaul.LOGGER.error("Invalid JSON syntax in {}: {}", (Object)configFile, (Object)e.getMessage());
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Unexpected error loading custom frames from {}: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static void extractDefaultConfigFile(Path targetFile, ResourceManager resourceManager) {
        block9: {
            try {
                Optional resource = resourceManager.getResource(ResourceLocation.fromNamespaceAndPath((String)CONFIG_SUBDIR, (String)"tooltipoverhaul/custom_frames.json"));
                if (resource.isPresent()) {
                    try (InputStream stream = ((Resource)resource.get()).open();){
                        Files.copy(stream, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        TooltipOverhaul.LOGGER.info("Extracted default custom_frames.json to config: {}", (Object)targetFile);
                        break block9;
                    }
                }
                TooltipOverhaul.LOGGER.warn("Could not find default custom_frames.json in mod resources");
                CustomFrameLoader.createEmptyConfigFile(targetFile);
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.error("Failed to extract default config file: {}", (Object)e.getMessage());
                CustomFrameLoader.createEmptyConfigFile(targetFile);
            }
        }
    }

    private static void createEmptyConfigFile(Path targetFile) {
        try {
            Files.writeString(targetFile, (CharSequence)"{\n  \"custom_frames\": []\n}", StandardCharsets.UTF_8, new OpenOption[0]);
            TooltipOverhaul.LOGGER.info("Created an empty custom_frames.json as a fallback at {}", (Object)targetFile);
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to create empty custom_frames.json config file: {}", (Object)e.getMessage());
        }
    }

    private static void loadFramesFromResource(Resource resource, Map<ResourceLocation, CustomFrameData> frames, ResourceLocation configLocation) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
            TooltipOverhaul.LOGGER.info("Loading custom frames from: {}", (Object)configLocation);
            CustomFrameConfig config = (CustomFrameConfig)GSON.fromJson((Reader)reader, CustomFrameConfig.class);
            if (config == null || config.getCustomFrames() == null) {
                TooltipOverhaul.LOGGER.warn("Empty or invalid custom frames config at {}", (Object)configLocation);
                return;
            }
            List<CustomFrameData> customFrames = config.getCustomFrames();
            String namespace = configLocation.getNamespace();
            TooltipOverhaul.LOGGER.debug("Found {} frame configs in {}", (Object)customFrames.size(), (Object)namespace);
            CustomFrameLoader.processFrameData(frames, customFrames, namespace);
        }
        catch (IOException e) {
            TooltipOverhaul.LOGGER.error("Failed to read custom frames file {}: {}", (Object)configLocation, (Object)e.getMessage());
        }
        catch (JsonSyntaxException e) {
            TooltipOverhaul.LOGGER.error("Invalid JSON syntax in {}: {}", (Object)configLocation, (Object)e.getMessage());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Unexpected error loading custom frames from {}: {}", new Object[]{configLocation, e.getMessage(), e});
        }
    }

    private static void processFrameData(Map<ResourceLocation, CustomFrameData> frames, List<CustomFrameData> customFrames, String namespace) {
        for (CustomFrameData frameData : customFrames) {
            List<ResourceLocation> itemLocations = frameData.getItemLocations();
            for (ResourceLocation item : itemLocations) {
                if (frames.containsKey(item)) {
                    TooltipOverhaul.LOGGER.debug("Duplicate frame for item {} in namespace {}, overwriting previous", (Object)item, (Object)namespace);
                }
                frames.put(item, frameData);
            }
            if (itemLocations.isEmpty() && !frameData.tags().isEmpty()) {
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("tag_only/" + Integer.toUnsignedString(System.identityHashCode(frameData), 36)));
                frames.put(key, frameData);
                TooltipOverhaul.LOGGER.debug("Registered tag-only entry {} with tags {}", (Object)key, frameData.tags());
            } else if (!frameData.tags().isEmpty()) {
                TooltipOverhaul.LOGGER.debug("Entry will also match tags (mixed): {}", frameData.tags());
            }
            if (!itemLocations.isEmpty() || !frameData.tags().isEmpty() || !frameData.namespace().isPresent() || frameData.namespace().get().trim().isEmpty()) continue;
            String currNamespace = frameData.namespace().get().trim();
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("namespace_only/" + currNamespace + "/" + Integer.toUnsignedString(System.identityHashCode(frameData), 36)));
            frames.put(key, frameData);
            TooltipOverhaul.LOGGER.debug("Registered namespace-only entry {} for namespace '{}'", (Object)key, (Object)currNamespace);
        }
    }
}

