/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import twilightforest.init.TFAdvancements;

public class HurtBossTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Entity hurt) {
        LootContext entity = EntityPredicate.createContext((ServerPlayer)player, (Entity)hurt);
        this.trigger(player, instance -> instance.matches(entity));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> hurt) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("hurt_entity").forGetter(TriggerInstance::hurt)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(LootContext hurt) {
            return this.hurt.isEmpty() || this.hurt.get().matches(hurt);
        }

        public static Criterion<TriggerInstance> hurtBoss(EntityPredicate.Builder hurt) {
            return ((HurtBossTrigger)((Object)TFAdvancements.HURT_BOSS.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate)hurt.build()))));
        }
    }
}

