/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.ITFCharger;
import twilightforest.entity.ai.goal.ChargeAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.util.entities.EntityUtil;

public class Minotaur
extends Monster
implements ITFCharger {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(Minotaur.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Minotaur(EntityType<? extends Minotaur> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ChargeAttackGoal((PathfinderMob)this, 1.5f, false));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARGING, (Object)false);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(accessor, difficulty, reason, data);
        this.populateDefaultEquipmentSlots(accessor.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(accessor, accessor.getRandom(), difficulty);
        return data;
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance difficulty) {
        float additionalDiff;
        int random = this.getRandom().nextInt(10);
        int result = (int)((float)random / (additionalDiff = difficulty.getEffectiveDifficulty() + 1.0f));
        if (result == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.GOLDEN_MINOTAUR_AXE.get()));
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_AXE));
        }
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.getEntityData().get(CHARGING);
    }

    @Override
    public void setCharging(boolean flag) {
        this.getEntityData().set(CHARGING, (Object)flag);
    }

    public boolean doHurtTarget(Entity entity) {
        return EntityUtil.properlyApplyCustomDamageSource((Mob)this, entity, TFDamageTypes.getEntityDamageSource(this.level(), TFDamageTypes.AXING, (Entity)this, new EntityType[0]), (SoundEvent)TFSounds.MINOTAUR_ATTACK.get());
    }

    public void aiStep() {
        super.aiStep();
        if (this.isCharging()) {
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + 0.6f);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.MINOTAUR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.MINOTAUR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.MINOTAUR_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)TFSounds.MINOTAUR_STEP.get(), 0.15f, 0.8f);
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.7f;
    }
}

