/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.enchantment.ApplyFrostedEffect;
import twilightforest.enchantment.RechargeScepterEffect;
import twilightforest.enchantment.SmashBlocksEffect;

public class TFEnchantments {
    public static final ResourceKey<Enchantment> FIRE_REACT = TFEnchantments.registerKey("fire_react");
    public static final ResourceKey<Enchantment> CHILL_AURA = TFEnchantments.registerKey("chill_aura");
    public static final ResourceKey<Enchantment> DESTRUCTION = TFEnchantments.registerKey("destruction");
    public static final ResourceKey<Enchantment> RENEWAL = TFEnchantments.registerKey("renewal");

    private static ResourceKey<Enchantment> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        TFEnchantments.register(context, FIRE_REACT, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)9), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.THORNS), enchantments.getOrThrow(CHILL_AURA)})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, (Object)AllOf.entityEffects((EnchantmentEntityEffect[])new EnchantmentEntityEffect[]{new Ignite((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f, (float)3.0f)), new DamageItem((LevelBasedValue)LevelBasedValue.constant((float)2.0f))}), LootItemRandomChanceCondition.randomChance((NumberProvider)EnchantmentLevelProvider.forEnchantmentLevel((LevelBasedValue)LevelBasedValue.perLevel((float)0.15f)))));
        TFEnchantments.register(context, CHILL_AURA, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)9), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.THORNS), enchantments.getOrThrow(FIRE_REACT)})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, (Object)AllOf.entityEffects((EnchantmentEntityEffect[])new EnchantmentEntityEffect[]{new ApplyFrostedEffect((LevelBasedValue)LevelBasedValue.constant((float)200.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)0.0f, (float)1.0f)), new DamageItem((LevelBasedValue)LevelBasedValue.constant((float)2.0f))}), LootItemRandomChanceCondition.randomChance((NumberProvider)EnchantmentLevelProvider.forEnchantmentLevel((LevelBasedValue)LevelBasedValue.perLevel((float)0.15f)))));
        TFEnchantments.register(context, DESTRUCTION, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ItemTagGenerator.BLOCK_AND_CHAIN_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)9), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)-1.5f))).withEffect(EnchantmentEffectComponents.HIT_BLOCK, (Object)new SmashBlocksEffect((LevelBasedValue)LevelBasedValue.constant((float)12.0f), (LevelBasedValue)LevelBasedValue.constant((float)1.0f), Optional.of((HolderSet)blocks.get(BlockTagGenerator.BLOCK_AND_CHAIN_NEVER_BREAKS).orElseThrow()), Optional.empty(), Optional.empty())));
        TFEnchantments.register(context, RENEWAL, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ItemTagGenerator.SCEPTERS), (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)9), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withEffect(EnchantmentEffectComponents.TICK, (Object)new RechargeScepterEffect()));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }
}

