/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.SimpleAdvancementTrigger;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;

public class GlassSwordItem
extends SwordItem {
    protected static final BlockParticleOption GLASS_PARTICLE = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.WHITE_STAINED_GLASS.defaultBlockState());

    public GlassSwordItem(Tier toolMaterial, Item.Properties properties) {
        super(toolMaterial, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.level() instanceof ServerLevel) {
            ParticlePacket particlePacket = new ParticlePacket();
            for (int i = 0; i < 20; ++i) {
                particlePacket.queueParticle((ParticleOptions)GLASS_PARTICLE, false, target.getX() + (double)(target.getRandom().nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth(), target.getY() + (double)(target.getRandom().nextFloat() * target.getBbHeight()), target.getZ() + (double)(target.getRandom().nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth(), 0.0, 0.0, 0.0);
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)target, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.hurtAndBreak(stack, attacker, user -> {
            user.level().playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), (SoundEvent)TFSounds.GLASS_SWORD_BREAK.get(), attacker.getSoundSource(), 1.0f, 0.5f);
            user.onEquippedItemBroken((Item)this, EquipmentSlot.MAINHAND);
        });
        return true;
    }

    private <T extends LivingEntity> void hurtAndBreak(ItemStack stack, T entity, Consumer<T> onBroken) {
        block5: {
            ServerPlayer sp;
            block6: {
                if (entity.level().isClientSide()) break block5;
                if (!(entity instanceof Player)) break block6;
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) break block5;
            }
            if (this.hurt(stack, entity instanceof ServerPlayer ? (sp = (ServerPlayer)entity) : null)) {
                onBroken.accept(entity);
                stack.shrink(1);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.awardStat(Stats.ITEM_BROKEN.get((Object)this));
                }
            }
        }
    }

    private boolean hurt(ItemStack stack, @Nullable ServerPlayer player) {
        if (stack.get(TFDataComponents.INFINITE_GLASS_SWORD) != null) {
            return false;
        }
        if (player != null) {
            if (EnchantmentHelper.processDurabilityChange((ServerLevel)player.serverLevel(), (ItemStack)stack, (int)1) <= 0) {
                return false;
            }
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(player, stack, 0);
            ((SimpleAdvancementTrigger)((Object)TFAdvancements.BROKE_GLASS_SWORD.get())).trigger(player);
        }
        return true;
    }
}

