/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.enums.HugeLilypadPiece;

public class HugeLilyPadItem
extends PlaceOnWaterBlockItem {
    public HugeLilyPadItem(HugeLilyPadBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult raytraceresult = HugeLilyPadItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            Direction direction = raytraceresult.getDirection();
            if (!(level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos.relative(direction), direction, itemstack) && level.mayInteract(player, blockpos.east()) && player.mayUseItemAt(blockpos.relative(direction).east(), direction, itemstack) && level.mayInteract(player, blockpos.south()) && player.mayUseItemAt(blockpos.relative(direction).south(), direction, itemstack) && level.mayInteract(player, blockpos.east().south()) && player.mayUseItemAt(blockpos.relative(direction).east().south(), direction, itemstack))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            BlockPos blockpos1 = blockpos.above();
            BlockState blockstate = level.getBlockState(blockpos);
            FluidState ifluidstate = level.getFluidState(blockpos);
            if ((ifluidstate.getType() == Fluids.WATER || blockstate.is(BlockTags.ICE)) && level.isEmptyBlock(blockpos1) && (level.getFluidState(blockpos.east()).getType() == Fluids.WATER || level.getBlockState(blockpos.east()).is(BlockTags.ICE)) && level.isEmptyBlock(blockpos1.east()) && (level.getFluidState(blockpos.south()).getType() == Fluids.WATER || level.getBlockState(blockpos.south()).is(BlockTags.ICE)) && level.isEmptyBlock(blockpos1.south()) && (level.getFluidState(blockpos.east().south()).getType() == Fluids.WATER || level.getBlockState(blockpos.east().south()).is(BlockTags.ICE)) && level.isEmptyBlock(blockpos1.east().south())) {
                BlockState lilypad = (BlockState)this.getBlock().defaultBlockState().setValue((Property)HugeLilyPadBlock.FACING, (Comparable)player.getDirection());
                level.setBlock(blockpos1, (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.NW)), 11);
                level.setBlock(blockpos1.east(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.NE)), 11);
                level.setBlock(blockpos1.east().south(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.SE)), 11);
                level.setBlock(blockpos1.south(), (BlockState)lilypad.setValue(HugeLilyPadBlock.PIECE, (Comparable)((Object)HugeLilypadPiece.SW)), 11);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1, itemstack);
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1.east(), itemstack);
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1.east().south(), itemstack);
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos1.south(), itemstack);
                }
                itemstack.consume(1, (LivingEntity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.playSound(player, blockpos, SoundEvents.LILY_PAD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResultHolder.success((Object)itemstack);
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

