/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.iterators;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class XZQuadrantIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final BinaryIntegerFunction<T> converter;
    private final int xConstant;
    private final int zConstant;
    private final int radius;
    private final int spacing;
    private int dX = 0;
    private int dZ = 1;
    private int cardinal = 0;

    public XZQuadrantIterator(int xConstant, int zConstant, boolean skipCenter, int radius, int spacing, BinaryIntegerFunction<T> converter) {
        this.converter = converter;
        this.xConstant = xConstant;
        this.zConstant = zConstant;
        this.radius = radius;
        this.spacing = spacing;
        if (!skipCenter) {
            this.dZ = 0;
            this.cardinal = -1;
        }
    }

    @Override
    public boolean hasNext() {
        return this.dX + 1 <= this.radius;
    }

    @Override
    public T next() {
        return switch (this.cardinal) {
            case 0 -> {
                ++this.cardinal;
                yield this.generate(this.dZ * this.spacing, -this.dX * this.spacing);
            }
            case 1 -> {
                ++this.cardinal;
                yield this.generate(-this.dX * this.spacing, -this.dZ * this.spacing);
            }
            case 2 -> {
                ++this.cardinal;
                yield this.generate(-this.dZ * this.spacing, this.dX * this.spacing);
            }
            default -> {
                this.cardinal = 0;
                T ret = this.generate(this.dX * this.spacing, this.dZ * this.spacing);
                this.tickXZ();
                yield ret;
            }
        };
    }

    private T generate(int dX, int dZ) {
        return this.converter.apply(this.xConstant + dX, this.zConstant + dZ);
    }

    private void tickXZ() {
        if (!this.hasNext()) {
            return;
        }
        if (this.dZ < this.radius) {
            ++this.dZ;
        } else {
            this.dZ = 1;
            ++this.dX;
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this;
    }

    public String toString() {
        return "XZQuadrantIterator{converter=" + String.valueOf(this.converter) + ", xConstant=" + this.xConstant + ", zConstant=" + this.zConstant + ", radius=" + this.radius + ", spacing=" + this.spacing + ", dX=" + this.dX + ", dZ=" + this.dZ + ", cardinal=" + this.cardinal + "}";
    }

    @FunctionalInterface
    public static interface BinaryIntegerFunction<T> {
        public T apply(int var1, int var2);
    }
}

