/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.features.FeaturePlacers;

public class LeafSpheroidFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<LeafSpheroidFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("horizontal_radius").forGetter(o -> Float.valueOf(o.horizontalRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("vertical_radius").forGetter(o -> Float.valueOf(o.verticalRadius)), (App)IntProvider.codec((int)0, (int)8).fieldOf("offset").forGetter(obj -> obj.offset), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_horizontal").orElse((Object)0).forGetter(o -> o.randomHorizontal), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_vertical").orElse((Object)0).forGetter(o -> o.randomVertical), (App)Codec.floatRange((float)-0.5f, (float)0.5f).fieldOf("vertical_filler_bias").orElse((Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.verticalBias)), (App)Codec.intRange((int)0, (int)256).fieldOf("shag_factor").orElse((Object)0).forGetter(o -> o.shag_factor)).apply((Applicative)instance, LeafSpheroidFoliagePlacer::new));
    private final float horizontalRadius;
    private final float verticalRadius;
    private final float verticalBias;
    private final int randomHorizontal;
    private final int randomVertical;
    private final int shag_factor;
    public static final LeafSpheroidFoliagePlacer NO_OP = new LeafSpheroidFoliagePlacer(0.0f, 0.0f, (IntProvider)ConstantInt.of((int)0), 0, 0, 0.0f, 0);

    public LeafSpheroidFoliagePlacer(float horizontalRadius, float verticalRadius, IntProvider yOffset, int randomHorizontal, int randomVertical, float verticalBias, int shag_factor) {
        super((IntProvider)ConstantInt.of((int)((int)horizontalRadius)), yOffset);
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
        this.verticalBias = verticalBias;
        this.shag_factor = shag_factor;
    }

    protected FoliagePlacerType<LeafSpheroidFoliagePlacer> type() {
        return (FoliagePlacerType)TFFeatureModifiers.FOLIAGE_SPHEROID.get();
    }

    protected void createFoliage(LevelSimulatedReader worldReader, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration baseTreeFeatureConfig, int trunkHeight, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int radius, int offset) {
        BlockPos center = foliage.pos().above(offset);
        FeaturePlacers.placeSpheroid(worldReader, setter, FeaturePlacers.VALID_TREE_POS, random, center, (float)foliage.radiusOffset() + this.horizontalRadius + (float)random.nextInt(this.randomHorizontal + 1), (float)foliage.radiusOffset() + this.verticalRadius + (float)random.nextInt(this.randomVertical + 1), this.verticalBias, baseTreeFeatureConfig.foliageProvider);
        if (this.shag_factor > 0) {
            for (int i = 0; i < this.shag_factor; ++i) {
                float randomYaw = random.nextFloat() * ((float)Math.PI * 2);
                float randomPitch = random.nextFloat() * 2.0f - 1.0f;
                float yUnit = Mth.sqrt((float)(1.0f - randomPitch * randomPitch));
                float xCircleOffset = yUnit * Mth.cos((float)randomYaw) * (this.horizontalRadius - 1.0f);
                float zCircleOffset = yUnit * Mth.sin((float)randomYaw) * (this.horizontalRadius - 1.0f);
                BlockPos placement = center.offset((int)(xCircleOffset + (float)((int)xCircleOffset >> 31)), (int)(randomPitch * (this.verticalRadius + 0.25f) + this.verticalBias), (int)(zCircleOffset + (float)((int)zCircleOffset >> 31)));
                LeafSpheroidFoliagePlacer.placeLeafCluster(worldReader, setter, random, placement.immutable(), baseTreeFeatureConfig.foliageProvider);
            }
        }
    }

    private static void placeLeafCluster(LevelSimulatedReader worldReader, FoliagePlacer.FoliageSetter setter, RandomSource random, BlockPos pos, BlockStateProvider state) {
        FeaturePlacers.placeLeaf(worldReader, setter, FeaturePlacers.VALID_TREE_POS, pos, state, random);
        FeaturePlacers.placeLeaf(worldReader, setter, FeaturePlacers.VALID_TREE_POS, pos.east(), state, random);
        FeaturePlacers.placeLeaf(worldReader, setter, FeaturePlacers.VALID_TREE_POS, pos.south(), state, random);
        FeaturePlacers.placeLeaf(worldReader, setter, FeaturePlacers.VALID_TREE_POS, pos.offset(1, 0, 1), state, random);
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration baseTreeFeatureConfig) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

