/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main.network.payloads;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncOverlaysPayload(Map<BlockPos, CompoundTag> tags) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncOverlaysPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"underlay", (String)"sync_overlays"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncOverlaysPayload> STREAM_CODEC = CustomPacketPayload.codec(SyncOverlaysPayload::write, SyncOverlaysPayload::read);

    public static SyncOverlaysPayload read(RegistryFriendlyByteBuf buf) {
        int size = buf.readVarInt();
        HashMap<BlockPos, CompoundTag> tags = new HashMap<BlockPos, CompoundTag>();
        for (int i = 0; i < size; ++i) {
            tags.put(buf.readBlockPos(), buf.readNbt());
        }
        return new SyncOverlaysPayload(tags);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.tags.size());
        for (Map.Entry<BlockPos, CompoundTag> e : this.tags.entrySet()) {
            buf.writeBlockPos(e.getKey());
            buf.writeNbt((Tag)e.getValue());
        }
    }

    public CustomPacketPayload.Type<SyncOverlaysPayload> type() {
        return TYPE;
    }
}

