/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.item;

import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;

public class AngelBlockItem
extends BlockItem {
    public AngelBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        BlockPos pos = pPlayer.blockPosition().relative(pPlayer.getDirection(), 2).above();
        if (pPlayer.getXRot() < -70.0f) {
            pos = pPlayer.blockPosition().above(3);
        } else if (pPlayer.getXRot() > 70.0f) {
            pos = pPlayer.blockPosition().below(1);
        }
        if (pLevel.getBlockState(pos).isAir() && !pLevel.isOutsideBuildHeight(pos) && !EventHooks.onBlockPlace((Entity)pPlayer, (BlockSnapshot)BlockSnapshot.create((ResourceKey)pLevel.dimension(), (LevelAccessor)pLevel, (BlockPos)pos), (Direction)pPlayer.getDirection())) {
            if (!pLevel.isClientSide) {
                pLevel.setBlockAndUpdate(pos, ((Block)UtilityBlockModule.ANGEL_BLOCK.get()).defaultBlockState());
                if (!pPlayer.isCreative()) {
                    pPlayer.getItemInHand(pUsedHand).shrink(1);
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide());
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }
}

