/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.data;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.drex.villagerconfig.common.mixin.MerchantOfferAccessor;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class BehaviorTrade
implements VillagerTrades.ItemListing {
    public static final Codec<BehaviorTrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootPoolEntries.CODEC.fieldOf("cost_a").forGetter(behaviorTrade -> behaviorTrade.costA), (App)LootPoolEntries.CODEC.optionalFieldOf("cost_b").forGetter(behaviorTrade -> behaviorTrade.costB), (App)LootPoolEntries.CODEC.fieldOf("result").forGetter(behaviorTrade -> behaviorTrade.result), (App)NumberProviders.CODEC.optionalFieldOf("price_multiplier", (Object)ConstantValue.exactly((float)0.2f)).forGetter(behaviorTrade -> behaviorTrade.priceMultiplier), (App)NumberProviders.CODEC.optionalFieldOf("trader_experience", (Object)ConstantValue.exactly((float)0.0f)).forGetter(behaviorTrade -> behaviorTrade.traderExperience), (App)NumberProviders.CODEC.optionalFieldOf("max_uses", (Object)ConstantValue.exactly((float)12.0f)).forGetter(behaviorTrade -> behaviorTrade.maxUses), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(behaviorTrade -> behaviorTrade.conditions), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)NumberProviders.CODEC).optionalFieldOf("reference_providers", Map.of()).forGetter(behaviorTrade -> behaviorTrade.referenceProviders), (App)Codec.BOOL.optionalFieldOf("reward_experience", (Object)true).forGetter(behaviorTrade -> behaviorTrade.rewardExperience)).apply((Applicative)instance, BehaviorTrade::new));
    private final LootPoolEntryContainer costA;
    private final Optional<LootPoolEntryContainer> costB;
    private final LootPoolEntryContainer result;
    private final NumberProvider priceMultiplier;
    private final NumberProvider traderExperience;
    private final NumberProvider maxUses;
    protected final Predicate<LootContext> compositeCondition;
    private final List<LootItemCondition> conditions;
    private final Map<String, NumberProvider> referenceProviders;
    private final boolean rewardExperience;

    BehaviorTrade(LootPoolEntryContainer costA, Optional<LootPoolEntryContainer> costB, LootPoolEntryContainer result, NumberProvider priceMultiplier, NumberProvider traderExperience, NumberProvider maxUses, List<LootItemCondition> conditions, Map<String, NumberProvider> referenceProviders, boolean rewardExperience) {
        this.costA = costA;
        this.costB = costB;
        this.result = result;
        this.priceMultiplier = priceMultiplier;
        this.traderExperience = traderExperience;
        this.maxUses = maxUses;
        this.conditions = conditions;
        this.compositeCondition = Util.allOf(conditions);
        this.referenceProviders = referenceProviders;
        this.rewardExperience = rewardExperience;
    }

    @Nullable
    public MerchantOffer getOffer(Entity entity, RandomSource random) {
        LootParams lootParams = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(VCLootContextParams.NUMBER_REFERENCE, this.generateNumberReferences(entity, random)).create(VCLootContextParams.VILLAGER_LOOT_CONTEXT);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        AtomicReference<ItemStack> costA = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        AtomicReference<ItemStack> costB = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        this.addRandomItem(result::set, lootContext, this.result);
        this.costB.ifPresent(container -> this.addRandomItem(costB::set, lootContext, (LootPoolEntryContainer)container));
        this.addRandomItem(costA::set, lootContext, this.costA);
        Optional<Object> itemCostB = Optional.empty();
        if (this.costB.isPresent()) {
            itemCostB = Optional.of(BehaviorTrade.convertToCost(costB.get()));
        }
        MerchantOffer tradeOffer = new MerchantOffer(BehaviorTrade.convertToCost(costA.get()), itemCostB, result.get(), this.maxUses.getInt(lootContext), this.traderExperience.getInt(lootContext), this.priceMultiplier.getFloat(lootContext));
        ((MerchantOfferAccessor)tradeOffer).setRewardExp(this.rewardExperience);
        return tradeOffer;
    }

    private static ItemCost convertToCost(ItemStack stack) {
        ItemCost itemCost = new ItemCost((ItemLike)stack.getItem(), stack.getCount());
        return itemCost.withComponents(builder -> {
            for (Map.Entry componentPatch : stack.getComponentsPatch().entrySet()) {
                Optional value = (Optional)componentPatch.getValue();
                DataComponentType key = (DataComponentType)componentPatch.getKey();
                value.ifPresent(o -> builder.expect(key, o));
            }
            return builder;
        });
    }

    private void addRandomItem(Consumer<ItemStack> consumer, LootContext lootContext, LootPoolEntryContainer lootPoolEntryContainer) {
        RandomSource randomSource = lootContext.getRandom();
        ArrayList entries = Lists.newArrayList();
        MutableInt totalWeight = new MutableInt();
        lootPoolEntryContainer.expand(lootContext, lootPoolEntry -> {
            int weight = lootPoolEntry.getWeight(lootContext.getLuck());
            if (weight > 0) {
                entries.add(lootPoolEntry);
                totalWeight.add(weight);
            }
        });
        int size = entries.size();
        if (totalWeight.intValue() == 0 || size == 0) {
            return;
        }
        if (size == 1) {
            ((LootPoolEntry)entries.getFirst()).createItemStack(itemStack -> BehaviorTrade.limitCount(consumer, itemStack), lootContext);
            return;
        }
        int j = randomSource.nextInt(totalWeight.intValue());
        for (LootPoolEntry lootPoolEntry2 : entries) {
            if ((j -= lootPoolEntry2.getWeight(lootContext.getLuck())) >= 0) continue;
            lootPoolEntry2.createItemStack(itemStack -> BehaviorTrade.limitCount(consumer, itemStack), lootContext);
            return;
        }
    }

    private static void limitCount(Consumer<ItemStack> consumer, ItemStack itemStack) {
        consumer.accept(itemStack.copyWithCount(Math.min(itemStack.getMaxStackSize(), itemStack.getCount())));
    }

    private Map<String, Float> generateNumberReferences(Entity entity, RandomSource random) {
        LootParams lootParams = new LootParams.Builder((ServerLevel)entity.level()).create(LootContextParamSets.EMPTY);
        LootContext simpleContext = new LootContext.Builder(lootParams).create(Optional.empty());
        return this.referenceProviders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((NumberProvider)entry.getValue()).getFloat(simpleContext))));
    }

    public static class Builder {
        private final LootPoolEntryContainer costA;
        private Optional<LootPoolEntryContainer> costB = Optional.empty();
        private final LootPoolEntryContainer result;
        private NumberProvider priceMultiplier = ConstantValue.exactly((float)0.2f);
        private NumberProvider traderExperience = ConstantValue.exactly((float)1.0f);
        private NumberProvider maxUses = ConstantValue.exactly((float)12.0f);
        private final List<LootItemCondition> conditions = Lists.newArrayList();
        private final Map<String, NumberProvider> referenceProviders = new HashMap<String, NumberProvider>();
        private boolean rewardExperience = true;

        public Builder(LootPoolEntryContainer.Builder<?> costA, LootPoolEntryContainer.Builder<?> result) {
            this.costA = costA.build();
            this.result = result.build();
        }

        public Builder(LootPoolEntryContainer.Builder<?> costA, LootPoolEntryContainer.Builder<?> costB, LootPoolEntryContainer.Builder<?> result) {
            this.costA = costA.build();
            this.costB = Optional.of(costB.build());
            this.result = result.build();
        }

        public Builder priceMultiplier(float priceMultiplier) {
            return this.priceMultiplier((NumberProvider)ConstantValue.exactly((float)priceMultiplier));
        }

        public Builder priceMultiplier(NumberProvider priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder traderExperience(float traderExp) {
            return this.traderExperience((NumberProvider)ConstantValue.exactly((float)traderExp));
        }

        public Builder traderExperience(NumberProvider traderExp) {
            this.traderExperience = traderExp;
            return this;
        }

        public Builder when(LootItemCondition.Builder builder) {
            this.conditions.add(builder.build());
            return this;
        }

        public Builder maxUses(float maxUses) {
            return this.maxUses((NumberProvider)ConstantValue.exactly((float)maxUses));
        }

        public Builder maxUses(NumberProvider maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder numberReference(String id, NumberProvider numberProvider) {
            this.referenceProviders.put(id, numberProvider);
            return this;
        }

        public Builder rewardExperience(boolean rewardExp) {
            this.rewardExperience = rewardExp;
            return this;
        }

        public BehaviorTrade build() {
            return new BehaviorTrade(this.costA, this.costB, this.result, this.priceMultiplier, this.traderExperience, this.maxUses, this.conditions, this.referenceProviders, this.rewardExperience);
        }
    }
}

