/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.mixin;

import com.mojang.serialization.Codec;
import me.drex.villagerconfig.common.config.ConfigManager;
import net.minecraft.util.Mth;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MerchantOffer.class})
public abstract class MerchantOfferMixin {
    @Shadow
    @Final
    private ItemCost baseCostA;
    @Shadow
    @Final
    public static Codec<MerchantOffer> CODEC;

    @Redirect(method={"addToSpecialPriceDiff"}, at=@At(value="FIELD", target="Lnet/minecraft/world/item/trading/MerchantOffer;specialPriceDiff:I", opcode=181))
    public void adjustSpecialPrice(MerchantOffer tradeOffer, int increment) {
        int maxDiscount = (int)((double)this.baseCostA.count() * -(ConfigManager.CONFIG.features.maxDiscount / 100.0));
        int maxRaise = (int)((double)this.baseCostA.count() * (ConfigManager.CONFIG.features.maxRaise / 100.0));
        tradeOffer.setSpecialPriceDiff(Mth.clamp((int)(tradeOffer.getSpecialPriceDiff() + increment), (int)maxDiscount, (int)maxRaise));
    }

    @Inject(method={"isOutOfStock"}, at={@At(value="HEAD")}, cancellable=true)
    public void addOldTradeMechanics(CallbackInfoReturnable<Boolean> cir) {
        if (ConfigManager.CONFIG.features.infiniteTrades) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getMaxUses"}, at={@At(value="HEAD")}, cancellable=true)
    public void infiniteUses(CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.CONFIG.features.infiniteTrades) {
            cir.setReturnValue((Object)Integer.MAX_VALUE);
        }
    }

    @Inject(method={"updateDemand"}, at={@At(value="HEAD")}, cancellable=true)
    public void noDemand(CallbackInfo ci) {
        if (ConfigManager.CONFIG.features.infiniteTrades) {
            ci.cancel();
        }
    }
}

