/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.commands.VillagerConfigCommand;
import me.drex.villagerconfig.common.config.ConfigScreen;
import me.drex.villagerconfig.common.protocol.ClientboundMerchantXpPacket;
import me.drex.villagerconfig.neoforge.util.NeoForgeTradeManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="villagerconfig")
public final class VillagerConfigNeoForge {
    public static String MOD_VERSION = null;

    public VillagerConfigNeoForge(ModContainer modContainer, IEventBus modEventBus) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        MOD_VERSION = modContainer.getModInfo().getVersion().toString();
        VillagerConfig.initialize();
        eventBus.addListener(VillagerConfigNeoForge::onRegisterCommands);
        eventBus.addListener(VillagerConfigNeoForge::onAddReloadListener);
        modEventBus.addListener(VillagerConfigNeoForge::registerCommon);
        if (FMLEnvironment.dist == Dist.CLIENT && ModList.get().isLoaded("cloth_config")) {
            modEventBus.addListener(VillagerConfigNeoForge::onClientSetup);
        }
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        VillagerConfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, screen) -> ConfigScreen.getConfigScreen(screen)));
    }

    public static void registerCommon(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(ClientboundMerchantXpPacket.ID, ClientboundMerchantXpPacket.CODEC, (IPayloadHandler)new DirectionalPayloadHandler((payload, context) -> payload.handle(context.player()), (payload, context) -> payload.handle(context.player())));
    }

    private static void onAddReloadListener(AddReloadListenerEvent event) {
        VillagerConfig.TRADE_MANAGER = new NeoForgeTradeManager((HolderLookup.Provider)event.getRegistryAccess());
        event.addListener((PreparableReloadListener)VillagerConfig.TRADE_MANAGER);
    }
}

