/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router;

import java.util.function.Supplier;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.router.client.GuiRouter;
import mcjty.xnet.modules.router.data.RouterData;
import mcjty.xnet.setup.Registration;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.registries.DeferredHolder;

public class RouterModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, TileEntityRouter> ROUTER = Registration.RBLOCKS.registerBlock("router", TileEntityRouter.class, TileEntityRouter::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), TileEntityRouter::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_ROUTER = Registration.CONTAINERS.register("router", GenericContainer::createContainerType);
    public static final Supplier<AttachmentType<RouterData>> ROUTER_DATA = Registration.ATTACHMENT_TYPES.register("router_data", () -> AttachmentType.builder(() -> RouterData.EMPTY).serialize(RouterData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<RouterData>> ITEM_ROUTER_DATA = Registration.COMPONENTS.registerComponentType("router_data", builder -> builder.persistent(RouterData.CODEC).networkSynchronized(RouterData.STREAM_CODEC));

    public RouterModule(IEventBus bus) {
        bus.addListener(this::registerScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        GuiRouter.register(event);
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(ROUTER).ironPickaxeTags().parentedItem("block/router").standardLoot(new DataComponentType[]{(DataComponentType)ITEM_ROUTER_DATA.get()}).blockState(p -> {
            ModelFile modelOk = p.frontBasedModel("router", p.modLoc("block/machine_router"));
            ModelFile modelError = p.frontBasedModel("router_error", p.modLoc("block/machine_router_error"));
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)ROUTER.block().get());
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelOk), direction);
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelError), direction);
            }
        }).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('I'), (ItemLike)Items.POWERED_RAIL).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"ICI", "rFr", "ioi"})});
    }
}

