/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.FluidResource;

public record RecordFluidContainer(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity, @ApiStatus.Internal @Nullable Runnable updateCallback) implements IResourceContainer<FluidResource>
{
    public RecordFluidContainer(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity, @Nullable Runnable updateCallback) {
        Objects.requireNonNull(resourceStacks);
        Objects.checkIndex(0, resourceStacks.size());
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
    }

    public static RecordFluidContainer of() {
        return RecordFluidContainer.of(1, 1000);
    }

    public static RecordFluidContainer of(int size, int capacity) {
        return RecordFluidContainer.of(size, capacity, null);
    }

    public static RecordFluidContainer of(int size, int capacity, @Nullable Runnable updateCallback) {
        return new RecordFluidContainer(MutableResourceStack.Empty.FLUID.nonNullListOfSize(size), capacity, updateCallback);
    }

    public static RecordFluidContainer from(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity) {
        return RecordFluidContainer.from(resourceStacks, capacity, null);
    }

    public static RecordFluidContainer from(NonNullList<MutableResourceStack<FluidResource>> resourceStacks, int capacity, Runnable updateCallback) {
        RecordFluidContainer container = RecordFluidContainer.of(resourceStacks.size(), capacity, updateCallback);
        for (int i = 0; i < resourceStacks.size(); ++i) {
            container.set(i, (MutableResourceStack)resourceStacks.get(i));
        }
        return container;
    }

    @Override
    @NotNull
    public MutableResourceStack<FluidResource> defaultResource() {
        return MutableResourceStack.Empty.FLUID;
    }

    @Override
    public int size() {
        return this.resourceStacks.size();
    }

    @Override
    public boolean isValid(int index, @NotNull FluidResource resource) {
        Objects.checkIndex(index, this.size());
        return true;
    }

    @Override
    public int getCapacity(int index, @NotNull FluidResource resource) {
        return this.capacity;
    }

    @Override
    public int getCapacity(int index) {
        return this.capacity;
    }

    @Override
    @NotNull
    public MutableResourceStack<FluidResource> get(int index) {
        Objects.checkIndex(index, this.size());
        return (MutableResourceStack)this.resourceStacks.get(index);
    }

    @Override
    public void set(int index, @NotNull MutableResourceStack<FluidResource> stack) {
        Objects.checkIndex(index, this.size());
        this.resourceStacks.set(index, stack);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public void clear() {
        Collections.fill(this.resourceStacks, this.defaultResource());
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    @NotNull
    public IResourceContainer<FluidResource> slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    private class Slice
    implements IResourceContainer<FluidResource> {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        @NotNull
        public MutableResourceStack<FluidResource> get(int index) {
            Objects.checkIndex(index, this.size());
            return RecordFluidContainer.this.get(index + this.start);
        }

        @Override
        public void set(int index, @NotNull MutableResourceStack<FluidResource> stack) {
            Objects.checkIndex(index, this.size());
            RecordFluidContainer.this.set(index + this.start, stack);
        }

        @Override
        public int getCapacity(int index, @NotNull FluidResource resource) {
            Objects.checkIndex(index, this.size());
            return RecordFluidContainer.this.getCapacity(index + this.start, resource);
        }

        @Override
        public int getCapacity(int index) {
            Objects.checkIndex(index, this.size());
            return RecordFluidContainer.this.getCapacity(index + this.start);
        }

        @Override
        public boolean isValid(int index, @NotNull FluidResource stack) {
            Objects.checkIndex(index, this.size());
            return RecordFluidContainer.this.isValid(index + this.start, stack);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.length; ++i) {
                RecordFluidContainer.this.resourceStacks.set(i + this.start, this.defaultResource());
            }
            if (RecordFluidContainer.this.updateCallback != null) {
                RecordFluidContainer.this.updateCallback.run();
            }
        }

        @Override
        @NotNull
        public IResourceContainer<FluidResource> slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return new Slice(this.start + from, to - from);
        }

        @Override
        @NotNull
        public MutableResourceStack<FluidResource> defaultResource() {
            return RecordFluidContainer.this.defaultResource();
        }
    }
}

