/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.resource;

import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item2.ItemHandlerToContainerAdapter;
import tv.soaryn.xycraft.core.container.item2.VanillaToItemContainerAdapter;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.container.resource.ResourceContainerSlice;
import tv.soaryn.xycraft.core.container.resource.ResourceContainerToHandlerAdapter;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandler;
import tv.soaryn.xycraft.core.utils.protocontainer.IResourceHandlerModifiable;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ResourceStack;

public interface IResourceContainer<TResource extends IResource>
extends Iterable<MutableResourceStack<TResource>> {
    @Contract(pure=true)
    public int size();

    @Contract(pure=true)
    public int getCapacity(int var1);

    default public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.defaultResource());
        }
    }

    @Contract(pure=true)
    default public boolean isEmpty() {
        for (int index = 0; index < this.size(); ++index) {
            if (this.get(index).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static IResourceContainer<ItemResource> wrap(@NotNull Container container) {
        return new VanillaToItemContainerAdapter(container);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static IResourceContainer<ItemResource> wrap(@NotNull IResourceHandler<ItemResource> handler) {
        return new ItemHandlerToContainerAdapter(handler);
    }

    @NotNull
    public MutableResourceStack<TResource> get(int var1);

    public void set(int var1, @NotNull MutableResourceStack<TResource> var2);

    @Contract(pure=true)
    default public boolean isValid(int index, @NotNull TResource resource) {
        Objects.checkIndex(index, this.size());
        return true;
    }

    @Contract(pure=true)
    public int getCapacity(int var1, @NotNull TResource var2);

    @Override
    @Contract(value="-> new", pure=true)
    @NotNull
    default public Iterator<MutableResourceStack<TResource>> iterator() {
        return new Iterator<MutableResourceStack<TResource>>(){
            final int size;
            int i;
            {
                this.size = IResourceContainer.this.size();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public MutableResourceStack<TResource> next() {
                return IResourceContainer.this.get(this.i++);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    default public IResourceContainer<TResource> slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new ResourceContainerSlice(this, from, to - from);
    }

    @Contract(pure=true)
    @NotNull
    default public IResourceHandlerModifiable<TResource> asHandler() {
        return this.asHandler(HandlerIOBehavior.DEFAULT);
    }

    @Contract(pure=true)
    @NotNull
    default public IResourceHandlerModifiable<TResource> asHandler(HandlerIOBehavior behavior) {
        return new ResourceContainerToHandlerAdapter(this, behavior);
    }

    @NotNull
    public MutableResourceStack<TResource> defaultResource();

    @Contract(pure=true)
    @NotNull
    default public NonNullList<MutableResourceStack<TResource>> copyToList() {
        NonNullList list = NonNullList.withSize((int)this.size(), this.defaultResource());
        for (int index = 0; index < this.size(); ++index) {
            list.set(index, this.get(index));
        }
        return list;
    }

    @NotNull
    default public NonNullList<ResourceStack<TResource>> immutableList() {
        NonNullList list = NonNullList.withSize((int)this.size(), this.defaultResource().immutable());
        for (int index = 0; index < this.size(); ++index) {
            list.set(index, this.get(index).immutable());
        }
        return list;
    }
}

