/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.resource;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;

public abstract class ResourceListContainer<T extends IResource>
implements IResourceContainer<T> {
    private final NonNullList<MutableResourceStack<T>> _resourceStacks;
    @Nullable
    private final Runnable _updateCallback;
    private final MutableResourceStack<T> _emptyStack;

    public ResourceListContainer(NonNullList<MutableResourceStack<T>> resourceStacks, @Nullable Runnable updateCallback, MutableResourceStack<T> emptyStack) {
        Objects.requireNonNull(resourceStacks);
        Objects.checkIndex(0, resourceStacks.size());
        this._resourceStacks = resourceStacks;
        this._updateCallback = updateCallback;
        this._emptyStack = emptyStack;
    }

    @Override
    @NotNull
    public MutableResourceStack<T> defaultResource() {
        return this._emptyStack;
    }

    @Override
    public int size() {
        return this._resourceStacks.size();
    }

    @Override
    public boolean isValid(int index, @NotNull T resource) {
        Objects.checkIndex(index, this.size());
        return true;
    }

    @Override
    @NotNull
    public MutableResourceStack<T> get(int index) {
        Objects.checkIndex(index, this.size());
        return (MutableResourceStack)this._resourceStacks.get(index);
    }

    @Override
    public void set(int index, @NotNull MutableResourceStack<T> stack) {
        Objects.checkIndex(index, this.size());
        this._resourceStacks.set(index, stack);
        if (this._updateCallback != null) {
            this._updateCallback.run();
        }
    }

    @Override
    public void clear() {
        Collections.fill(this._resourceStacks, this.defaultResource());
        if (this._updateCallback != null) {
            this._updateCallback.run();
        }
    }

    @Override
    @NotNull
    public IResourceContainer<T> slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    private class Slice
    implements IResourceContainer<T> {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        @NotNull
        public MutableResourceStack<T> get(int index) {
            Objects.checkIndex(index, this.size());
            return ResourceListContainer.this.get(index + this.start);
        }

        @Override
        public void set(int index, @NotNull MutableResourceStack<T> stack) {
            Objects.checkIndex(index, this.size());
            ResourceListContainer.this.set(index + this.start, stack);
        }

        @Override
        public int getCapacity(int index, @NotNull T resource) {
            Objects.checkIndex(index, this.size());
            return ResourceListContainer.this.getCapacity(index + this.start, resource);
        }

        @Override
        public int getCapacity(int index) {
            Objects.checkIndex(index, this.size());
            return ResourceListContainer.this.getCapacity(index + this.start);
        }

        @Override
        public boolean isValid(int index, @NotNull T stack) {
            Objects.checkIndex(index, this.size());
            return ResourceListContainer.this.isValid(index + this.start, stack);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.length; ++i) {
                ResourceListContainer.this._resourceStacks.set(i + this.start, this.defaultResource());
            }
            if (ResourceListContainer.this._updateCallback != null) {
                ResourceListContainer.this._updateCallback.run();
            }
        }

        @Override
        @NotNull
        public IResourceContainer<T> slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return new Slice(this.start + from, to - from);
        }

        @Override
        @NotNull
        public MutableResourceStack<T> defaultResource() {
            return ResourceListContainer.this.defaultResource();
        }
    }
}

