/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.ICapabilityCleanupBlockEntity;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;

public class CleanupCapabilityTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    @Override
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return level.getBlockEntity(pos) instanceof ICapabilityCleanupBlockEntity;
    }

    @Override
    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
    }

    @Override
    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        super.tickBatchBlocks(level, tickData, pos, state, currentStep);
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (!(blockEntity instanceof ICapabilityCleanupBlockEntity)) {
            return;
        }
        ICapabilityCleanupBlockEntity cleanupBlock = (ICapabilityCleanupBlockEntity)blockEntity;
        if (!cleanupBlock.isDirtyEstimate()) {
            return;
        }
        Set<Direction> set = cleanupBlock.getDirtySides();
        if (set.isEmpty()) {
            return;
        }
        cleanupBlock.handleCleanup(level, tickData, (BlockPos)pos, state, currentStep, set);
    }

    @Override
    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return CoreAttachments.CapCleanupData;
    }
}

