/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector4f;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnergyConsumer;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.core.content.attachments.accessors.PlayerPowerLookup;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.handlers.EnergyHandlerUtils;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.MachinesModules;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.MineLogicModule;
import tv.soaryn.xycraft.machines.content.recipes.solidifier.SolidifierRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

@EventBusSubscriber(modid="xycraft_machines", value={Dist.CLIENT})
public class GauntletClient {
    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void renderBlockHighlights(RenderHighlightEvent.Block event) {
        MultiPlayerGameMode gameMode;
        Player player = Utils.getClientPlayer();
        ClientLevel level = (ClientLevel)Utils.getClientLevel();
        if (player == null || level == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        IModuleContainer cap = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM);
        if (cap == null) {
            return;
        }
        IEnergyConsumer consumable = (IEnergyConsumer)stack.getCapability(CoreCapabilities.EnergyConsumable.ITEM);
        if (consumable == null) {
            return;
        }
        List moduleList = cap.getInstalledModules();
        MineLogicModule module = null;
        boolean hasFreezeModule = false;
        for (IModuleContainer.ModuleRecord moduleRecord : moduleList) {
            IModule iModule = moduleRecord.module();
            if (iModule instanceof MineLogicModule) {
                MineLogicModule found;
                module = found = (MineLogicModule)iModule;
            }
            if (moduleRecord.module() != MachinesModules.Tunneler.value()) continue;
            hasFreezeModule = true;
        }
        if (module == null) {
            return;
        }
        if (!((Boolean)stack.getOrDefault(MachinesDataComponents.ToolActivation, (Object)false)).booleanValue()) {
            return;
        }
        BlockPos origin = event.getTarget().getBlockPos();
        Direction dir = event.getTarget().getDirection();
        BlockState originState = level.getBlockState(origin);
        if (originState.getDestroySpeed((BlockGetter)level, origin) < 0.0f) {
            return;
        }
        List<BlockPos> blockPositions = module.logic().getPositions((Level)level, origin, dir, 1).map(BlockPos::immutable).toList();
        if (blockPositions.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> frozenBlocks = new ArrayList<BlockPos>();
        if (hasFreezeModule) {
            for (BlockPos blockPosition : blockPositions) {
                for (Direction value : Direction.values()) {
                    BlockPos checkPos = blockPosition.relative(value);
                    if (blockPositions.contains(checkPos) || frozenBlocks.contains(checkPos) || !GauntletClient.canFreeze((Level)level, checkPos)) continue;
                    frozenBlocks.add(checkPos);
                }
            }
            frozenBlocks.removeAll(MineLogicModule.getRadiusBlocks(origin.relative(dir.getOpposite()), dir, 1).map(BlockPos::immutable).toList());
        }
        int energyRequired = player.isCreative() ? 0 : (blockPositions.size() + frozenBlocks.size()) * consumable.amountRequired(player);
        PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of((Player)player);
        lookup.invalidate(player.getInventory());
        long result = lookup.loop((long)energyRequired, EnergyHandlerUtils::simulateDrain);
        if (result < (long)energyRequired) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        VertexConsumer lines = event.getMultiBufferSource().getBuffer(RenderType.lines());
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.getPosition();
        if (!event.isCanceled()) {
            for (BlockPos blockPosition : blockPositions) {
                BlockState state = level.getBlockState(blockPosition);
                if (blockPosition.equals((Object)origin)) continue;
                VoxelShape voxelShape = state.getShape((BlockGetter)level, blockPosition).move((double)blockPosition.getX(), (double)blockPosition.getY(), (double)blockPosition.getZ());
                Vector4f color = new Vector4f(0.0f, 0.0f, 0.0f, 0.2f);
                if (blockPosition.equals((Object)origin)) {
                    color = new Vector4f(0.0f, 0.0f, 0.0f, 0.8f);
                }
                LevelRenderer.renderVoxelShape((PoseStack)poseStack, (VertexConsumer)lines, (VoxelShape)voxelShape, (double)(-cameraPos.x()), (double)(-cameraPos.y()), (double)(-cameraPos.z()), (float)color.x(), (float)color.y(), (float)color.z(), (float)color.w(), (boolean)false);
            }
        }
        if ((gameMode = Minecraft.getInstance().gameMode) == null || !gameMode.isDestroying()) {
            return;
        }
        int progress = gameMode.getDestroyStage();
        if (progress < 0 || progress > 10) {
            return;
        }
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        double cameraX = camera.getPosition().x();
        double cameraY = camera.getPosition().y();
        double cameraZ = camera.getPosition().z();
        for (BlockPos blockPos : blockPositions) {
            if (blockPos.equals((Object)origin)) continue;
            MultiBufferSource.BufferSource renderBuffers = Minecraft.getInstance().renderBuffers().crumblingBufferSource();
            BlockState state = level.getBlockState(blockPos);
            poseStack.pushPose();
            poseStack.translate((double)blockPos.getX() - cameraX, (double)blockPos.getY() - cameraY, (double)blockPos.getZ() - cameraZ);
            PoseStack.Pose matrixEntry = poseStack.last();
            SheetedDecalTextureGenerator matrixBuilder = new SheetedDecalTextureGenerator(renderBuffers.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(progress)), matrixEntry, 1.0f);
            ModelData modelData = level.getModelData(blockPos);
            dispatcher.renderBreakingTexture(state, blockPos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)matrixBuilder, modelData);
            poseStack.popPose();
        }
    }

    static boolean canFreeze(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)MachinesRecipeTypes.Solidifier.type().get(), (RecipeInput)((SolidifierRecipe.Input)() -> state), level);
        return recipe.isPresent() || !state.getFluidState().isEmpty();
    }
}

