/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tv.soaryn.xycraft.core.utils.Utils;

public final class FluidBlockRendering {
    private static final Quaternionf SetupOrthoProjectionQuat = new Quaternionf().rotationZ((float)Math.PI).mul((Quaternionfc)new Quaternionf().rotationX((float)Math.toRadians(30.0))).mul((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(45.0)));

    private FluidBlockRendering() {
    }

    public static void render(PoseStack stack, Fluid fluid, int x, int y, int width, int height) {
        FluidState fluidState;
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluidState = flowing.getSource().defaultFluidState();
        } else {
            fluidState = fluid.defaultFluidState();
        }
        FluidState fluidState2 = fluidState;
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        RenderSystem.runAsFancy(() -> {
            RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState2);
            renderType.setupRenderState();
            Matrix4fStack worldMatStack = RenderSystem.getModelViewStack();
            worldMatStack.pushMatrix();
            worldMatStack.mul((Matrix4fc)stack.last().pose());
            worldMatStack.translate((float)x, (float)y, 0.0f);
            FogRenderer.setupNoFog();
            worldMatStack.translate((float)width / 2.0f, (float)height / 2.0f, 200.0f);
            worldMatStack.scale((float)width * 0.625f, (float)height * 0.625f, 1.0f);
            FluidBlockRendering.setupOrthographicProjection(worldMatStack);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder builder = tesselator.begin(renderType.mode(), renderType.format());
            blockRenderer.renderLiquid(BlockPos.ZERO, (BlockAndTintGetter)new FakeWorld(fluidState2), (VertexConsumer)builder, fluidState2.createLegacyBlock(), fluidState2);
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            renderType.clearRenderState();
            worldMatStack.popMatrix();
        });
        RenderSystem.applyModelViewMatrix();
    }

    private static void setupOrthographicProjection(Matrix4fStack worldMatStack) {
        worldMatStack.scale(1.0f, 1.0f, 1.0f);
        worldMatStack.rotate((Quaternionfc)SetupOrthoProjectionQuat);
        worldMatStack.translate(-0.5f, -0.5f, -0.5f);
        RenderSystem.applyModelViewMatrix();
    }

    private static class FakeWorld
    implements BlockAndTintGetter {
        private final FluidState fluidState;

        public FakeWorld(FluidState fluidState) {
            this.fluidState = fluidState;
        }

        public float getShade(@NotNull Direction direction, boolean bl) {
            return 1.0f;
        }

        @NotNull
        public LevelLightEngine getLightEngine() {
            throw new UnsupportedOperationException();
        }

        public int getBrightness(@NotNull LightLayer lightLayer, @NotNull BlockPos blockPos) {
            return 15;
        }

        public int getRawBrightness(@NotNull BlockPos blockPos, int i) {
            return 15;
        }

        public int getBlockTint(@NotNull BlockPos blockPos, ColorResolver colorResolver) {
            Biome biome;
            Optional biomeRegistry;
            Level level = Utils.getClientLevel();
            if (level != null && (biomeRegistry = level.registryAccess().registry(Registries.BIOME)).isPresent() && (biome = (Biome)((Registry)biomeRegistry.get()).get(Biomes.THE_VOID)) != null) {
                return colorResolver.getColor(biome, 0.0, 0.0);
            }
            return -1;
        }

        public BlockEntity getBlockEntity(@NotNull BlockPos blockPos) {
            return null;
        }

        @NotNull
        public BlockState getBlockState(BlockPos blockPos) {
            return blockPos.equals((Object)BlockPos.ZERO) ? this.fluidState.createLegacyBlock() : Blocks.AIR.defaultBlockState();
        }

        @NotNull
        public FluidState getFluidState(BlockPos blockPos) {
            return blockPos.equals((Object)BlockPos.ZERO) ? this.fluidState : Fluids.EMPTY.defaultFluidState();
        }

        public int getHeight() {
            return 0;
        }

        public int getMinBuildHeight() {
            return 0;
        }
    }
}

