/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNet;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.machines.content.attachments.XynergyNodeBindingAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class XynergyNodeEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void rightClickOnBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Level level = event.getLevel();
        BlockPos posTarget = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        IXynergyNode nodeTarget = (IXynergyNode)level.getCapability(CoreCapabilities.XynergyNode.BLOCK, posTarget, null);
        if (nodeTarget == null) {
            return;
        }
        if (!stack.is(XyCraftTags.Items.XyActuator.tag())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IXynergyNet net = XynergyNet.of((ServerLevel)serverLevel);
            if (net == null) {
                return;
            }
            if (player.isShiftKeyDown()) {
                long value = net.getEnergy(posTarget);
                player.displayClientMessage((Component)Component.literal((String)XynergyNet.valueToString((long)value)).withStyle(value >= 0L ? ChatFormatting.GREEN : ChatFormatting.RED), true);
            } else {
                XynergyNodeBindingAttachment bindingData = (XynergyNodeBindingAttachment)player.getData(MachinesAttachments.Player.XynergyBindingCache);
                if (bindingData.Last != null) {
                    BlockPos posStored = bindingData.Last;
                    if (posTarget.equals((Object)posStored)) {
                        player.displayClientMessage((Component)Component.literal((String)"You can't bind this to itself"), true);
                        event.setCanceled(true);
                        return;
                    }
                    bindingData.Last = null;
                    IXynergyNode nodeStored = (IXynergyNode)level.getCapability(CoreCapabilities.XynergyNode.BLOCK, posStored, null);
                    if (nodeStored == null) {
                        return;
                    }
                    if (net.areNodesConnected(posTarget, posStored)) {
                        net.removeEdge(posTarget, posStored);
                    } else {
                        float distance = (float)posTarget.distSqr((Vec3i)posStored);
                        if (net.getEdgeCount(posStored) >= nodeStored.getEdgeLimit()) {
                            player.displayClientMessage((Component)Component.literal((String)"Too many connections on original node"), true);
                        } else if (net.getEdgeCount(posTarget) >= nodeTarget.getEdgeLimit()) {
                            player.displayClientMessage((Component)Component.literal((String)"Too many connections on target node"), true);
                        } else if (nodeTarget.canConnectTo(nodeStored, posStored, distance, player) && nodeStored.canConnectTo(nodeTarget, posTarget, distance, player)) {
                            net.addEdge(posTarget.immutable(), nodeTarget, posStored.immutable(), nodeStored);
                            player.displayClientMessage((Component)Component.literal((String)"Bound"), true);
                        }
                    }
                    if (ModifierKey.of((Player)player)) {
                        bindingData.Last = posTarget;
                    }
                } else {
                    bindingData.Last = posTarget;
                }
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }
}

