/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge;

import com.gravitlauncher.socketbridge.EmptyResponse;
import com.gravitlauncher.socketbridge.ErrorResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Registry {
    private final Map<String, Class<?>> map = new ConcurrentHashMap();
    private final Map<Class<?>, String> reverseMap = new ConcurrentHashMap();

    public static Registry makeDefaultRegistry() {
        Registry registry = new Registry();
        registry.register("error", ErrorResponse.class);
        registry.register("empty", EmptyResponse.class);
        return registry;
    }

    public void register(String string, Class<?> clazz) {
        this.map.put(string, clazz);
        this.reverseMap.put(clazz, string);
    }

    public void unregister(String string) {
        Class<?> clazz = this.map.remove(string);
        if (clazz != null) {
            this.reverseMap.remove(clazz);
        }
    }

    public <T> Class<T> get(String string) {
        return this.map.get(string);
    }

    public String get(Class<?> clazz) {
        return this.reverseMap.get(clazz);
    }
}

